<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="max-w-4xl mx-auto">
        <a href="<?php echo e(route('admin.kyc.index')); ?>" class="text-gray-400 hover:text-white mb-6 inline-block">&larr; Back</a>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700">
                <h4 class="text-lg font-bold text-white mb-4">Submitted Document</h4>
                <?php if(Str::endsWith($user->kyc, '.pdf')): ?>
                    <iframe src="<?php echo e(asset('storage/' . $user->kyc)); ?>" class="w-full h-[500px] border border-gray-600 rounded"></iframe>
                <?php else: ?>
                    <a href="<?php echo e(asset('storage/' . $user->kyc)); ?>" target="_blank">
                        <img src="<?php echo e(asset('storage/' . $user->kyc)); ?>" class="w-full h-auto rounded border border-gray-600 hover:opacity-90 transition" alt="KYC Doc">
                    </a>
                <?php endif; ?>
                <div class="mt-4 text-center">
                    <a href="<?php echo e(asset('storage/' . $user->kyc)); ?>" download class="text-indigo-400 text-sm hover:underline">Download Original File</a>
                </div>
            </div>

            
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 h-fit">
                <h4 class="text-lg font-bold text-white mb-4">Application Details</h4>
                <div class="space-y-3 text-sm mb-8">
                    <p class="text-gray-400">Applicant: <span class="text-white"><?php echo e($user->firstname); ?> <?php echo e($user->lastname); ?></span></p>
                    <p class="text-gray-400">Email: <span class="text-white"><?php echo e($user->email); ?></span></p>
                    <p class="text-gray-400">Status: <span class="text-white uppercase font-bold"><?php echo e($user->kyc_status); ?></span></p>
                    <p class="text-gray-400">Submitted: <span class="text-white"><?php echo e($user->updated_at->diffForHumans()); ?></span></p>
                </div>

                <?php if($user->kyc_status !== 'verified'): ?>
                    <div class="space-y-4">
                        <form action="<?php echo e(route('admin.kyc.approve', $user->id)); ?>" method="POST" onsubmit="return confirm('Approve this user?');">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="w-full py-3 bg-green-600 hover:bg-green-500 text-white font-bold rounded-lg transition-all">
                                Approve & Verify
                            </button>
                        </form>

                        <div class="relative flex py-2 items-center">
                            <div class="flex-grow border-t border-gray-700"></div>
                            <span class="flex-shrink-0 mx-4 text-gray-500 text-xs">OR REJECT</span>
                            <div class="flex-grow border-t border-gray-700"></div>
                        </div>

                        <form action="<?php echo e(route('admin.kyc.reject', $user->id)); ?>" method="POST" class="space-y-3">
                            <?php echo csrf_field(); ?>
                            <textarea name="reason" rows="3" required placeholder="Reason for rejection (e.g., blurry image, expired ID)..." class="w-full bg-gray-900 border border-gray-700 rounded-lg p-3 text-white text-sm focus:ring-red-500 focus:border-red-500"></textarea>
                            <button type="submit" class="w-full py-3 bg-red-600/20 border border-red-600 text-red-500 hover:bg-red-600 hover:text-white font-bold rounded-lg transition-all">
                                Reject Application
                            </button>
                        </form>
                    </div>
                <?php else: ?>
                    <div class="bg-green-900/20 border border-green-900 p-4 rounded text-center">
                        <p class="text-green-500 font-bold">This user is already verified.</p>
                        <p class="text-xs text-green-400 mt-1">Verified on <?php echo e(\Carbon\Carbon::parse($user->kyc_verified_at)->format('M d, Y')); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/admin/kyc/show.blade.php ENDPATH**/ ?>