<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\PaymentOptionController;
use App\Http\Controllers\TradeController;
use App\Http\Controllers\SharesController;
use App\Http\Controllers\InvestmentController; // User-facing Fixed Investment Plans controller
use App\Http\Controllers\StakeController;
use App\Http\Controllers\RefundController;
use App\Http\Controllers\PortfolioController;
use App\Http\Controllers\ReferralController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\InvestmentPlanController; // This seems to be the AdminInvestmentPlanController (old reference)
use App\Http\Controllers\CoinController;
use App\Http\Controllers\SignalController;
use App\Http\Controllers\CopyTradingController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\TradeStockController;
use App\Http\Controllers\WalletConnectController;
use App\Http\Controllers\ForexController;
use App\Http\Controllers\TradeHistoryController;
use App\Http\Controllers\PersonaController;
use App\Http\Controllers\UserProfileController;
use App\Http\Controllers\CardController;
use App\Http\Controllers\CardActivationController; // Don't forget to import this at the top!
use App\Http\Controllers\KycController; // Don't forget to import this at the top!
use App\Http\Controllers\Admin\AdminSignalController;
use App\Http\Controllers\Admin\AdminUserSignalSubscriptionController;
use App\Http\Controllers\Admin\AdminExpertTraderController;
use App\Http\Controllers\Admin\AdminStockController;

// NEW ADMIN CONTROLLERS FOR INVESTMENT CHANGES
use App\Http\Controllers\Admin\AdminInvestmentPlanController; // Explicitly for Admin Investment Plans
use App\Http\Controllers\Admin\AdminUserFixedInvestmentController; // Explicitly for Admin User Fixed Investments

use App\Http\Middleware\CheckAdminRole;
use Illuminate\Support\Facades\Route;
use App\Models\InvestmentPlan; // This import might be unused now if logic moved to controllers
use Illuminate\Support\Facades\Artisan; // For dev routes


// Route::get('/', function () {
//     return view('welcome');
// });


Route::get('/notification', [HomeController::class, 'notification'])->name('home.notification');

Route::get('/admin/sign-up', [AdminController::class, 'signup'])->name('admin.signup');
Route::get('/admin/login', [AdminController::class, 'login'])->name('admin.login');
Route::get('/onboarding', [AdminController::class, 'onboarding'])->name('admin.onboarding');
Route::get('/my-profile', [AdminController::class, 'profile'])->name('profile');
Route::get('/edit-my-profile', [AdminController::class, 'edit_profile'])->name('edit_profile');




// temp routes for clearing
// ------------------

// Clear application cache:
// Route::get('/clear-cache', function() {
//     Artisan::call('cache:clear');
// });
// // ———————————————————
// //Clear route cache:
// Route::get('/route-cache', function() {
//     Artisan::call('route:cache');
//     return 'Routes cache has been cleared';
// });
// // ———————————————————
// //Clear config cache:
// Route::get('/config-cache', function() {
//     Artisan::call('config:cache');
// return 'Config cache has been cleared';
// });
// // ———————————————————
// // Clear view cache:
// Route::get('/view-clear', function() {
//     Artisan::call('view:clear');
// return 'View cache has been cleared';
// });


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::put('/kyc-update', [ProfileController::class, 'kycUpdate'])->name('profile.kyc-update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('/blank', function () {
        return view('blank');
    })->name('blank');

    Route::get('/test-mail',[SharesController::class, 'dummyTestMail']);

    // User Profile Routes (Prefix: /user/profile)
    Route::prefix('user')->name('user.')->group(function () {
        Route::get('/profile', [UserProfileController::class, 'edit'])->name('profile.edit');
        Route::patch('/profile', [UserProfileController::class, 'update'])->name('profile.update');
        Route::put('/password', [UserProfileController::class, 'updatePassword'])->name('password.update');
    });

    // deposit
    Route::get('/deposit', [TransactionController::class, 'create_deposit'])->name('deposit');
    Route::post('/deposit', [TransactionController::class, 'storeDepositTransaction'])->name('deposit.store');
    // withdrawal
    Route::get('/withdraw', [TransactionController::class, 'create_withdrawal'])->name('withdrawal');
    Route::post('/withdraw', [TransactionController::class, 'storeTransaction'])->name('withdrawal.store');

    // claim shares
    Route::post('/claim-shares', [SharesController::class, 'claimShares'])->name('claim_shares.save');
    Route::put('/save-rating', [ReviewController::class, 'postRating'])->name('rating.store');

    // user wallet
    Route::get('/wallet', [WalletController::class, 'viewWallet'])->name('wallet.view');

    // Route::get('/', function () {return view('dashboard');})->name('dash');

    // Route::get('/dashboard', function () {
    //     $investment_plans = InvestmentPlan::all();
    //     return view('dashboard', compact('investment_plans'));
    // })->middleware(['auth', 'verified'])->name('dashboard');
    Route::get('/', [DashboardController::class, 'index'])->name('dash');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Card Activation Routes
    Route::prefix('user/card')->name('user.card.')->group(function () {
        Route::get('/activate', [CardActivationController::class, 'show'])->name('activate');
        Route::post('/activate', [CardActivationController::class, 'store'])->name('submit_activation');
    });
    Route::post('/card/toggle-freeze', [CardActivationController::class, 'toggleFreeze'])->name('user.card.toggle_freeze');

    Route::get('/user/cards', [CardController::class, 'index'])->name('user.cards');

    Route::get('/kyc', [KycController::class, 'index'])->name('kyc.index');
    Route::post('/kyc', [KycController::class, 'store'])->name('kyc.store');

    // trade
    Route::resource('/trade', TradeController::class);
    Route::get('/trade-history', [TradeController::class, 'tradeHistory'])->name('trade.history');
    Route::get('/transaction-history', [TransactionController::class, 'transactionHistory'])->name('transaction.history');



    // **END OF INVESTMENT CHANGES**

    // stake
    // Route::resource('/stake', StakeController::class);

    // **START OF INVESTMENT CHANGES**
    // User-facing Fixed Investment Plans
    Route::get('/stake_', [InvestmentController::class, 'index'])->name('investment.index');
    Route::post('/stake_', [InvestmentController::class, 'store'])->name('investment.store');
    Route::get('/stake', [InvestmentController::class, 'index'])->name('stake.index');
    Route::post('/stake', [InvestmentController::class, 'store'])->name('stake.store');

    // portfolio
    Route::get('/portfolio', [PortfolioController::class, 'index'])->name('portfolio');

    // refunds
    Route::resource('/request-refund', RefundController::class);

    // referral
    Route::get('/referral', [ReferralController::class, 'view'])->name('referral');

    // signals
    Route::get('/signals', [SignalController::class, 'index'])->name('signals.index');
    Route::post('/signals/subscribe', [SignalController::class, 'subscribe'])->name('signals.subscribe');
    Route::get('/my-signals', [SignalController::class, 'mySignals'])->name('signals.my-signals');

    // User Copy Trading
    Route::get('/copytrading', [CopyTradingController::class, 'index'])->name('copytrading.index');
    Route::post('/copytrading/start', [CopyTradingController::class, 'startReplication'])->name('copytrading.start');
    Route::put('/copytrading/stop/{userReplication}', [CopyTradingController::class, 'stopReplication'])->name('copytrading.stop');
    Route::get('/my-copytrades', [CopyTradingController::class, 'myCopyTrades'])->name('copytrading.my-copytrades');

    Route::get('/api/user-stock/{stockId}', [StockController::class, 'getUserStockAmount']);
    Route::get('api/stocks/{stockCode}', [StockController::class, 'apiStocks'])->name('api.stocks');

    Route::middleware('auth:sanctum')->get('/api/user/data', [UserController::class, 'getUserData']);
    Route::middleware(['auth:sanctum'])->group(function () {
        Route::post('/api/trade', [TradeStockController::class, 'executeTrade']);
        // Route::get('/stocks/{code}', [TradingController::class, 'getStockDetails']);

        // Get Forex Details
        Route::get('/api/forex/{id}', [ForexController::class, 'show']);
        // Place Forex Trade
        Route::post('/api/trade/forex', [ForexController::class, 'store']);
    });
    Route::post('/trade-stock', [TradeStockController::class, 'storeTrade'])->name('trade-stock.store');
    // Route::get('/trade-history', [TradeStockController::class, 'history'])->name('trade.history');

    // View History Page
    Route::get('/trades/history', [TradeHistoryController::class, 'index'])->name('trades.history');

    // Action to Close Position
    Route::post('/trades/forex/close', [TradeHistoryController::class, 'closeForexPosition'])->name('trades.forex.close');

    // Inside your auth middleware group
    Route::get('/wallet-connect', [WalletConnectController::class, 'index'])->name('wallet-connect');
    // You can place this in a dedicated API routes file
    Route::post('/api/wallet-connect', [WalletConnectController::class, 'connect'])->name('wallet.connect');

    Route::post('/user/crypto/send', [App\Http\Controllers\CryptoTransferController::class, 'send'])->name('user.crypto.send')->middleware('auth');

    // admin routes
    Route::middleware([CheckAdminRole::class])->group(function () {
        Route::prefix('admin')->as('admin.')->group(function () {
            // Personas Management
            Route::patch('/personas/{persona}/activate', [PersonaController::class, 'activate'])->name('personas.activate');
            Route::resource('personas', PersonaController::class);

            // General Card Management
            Route::get('/cards', [CardActivationController::class, 'adminCardList'])->name('cards');
            Route::patch('/cards/{id}/status', [CardActivationController::class, 'updateCardStatus'])->name('cards.status');

            // List all pending requests
            Route::get('/card-requests', [CardActivationController::class, 'adminIndex'])->name('card.requests');

            // View specific encrypted request details
            Route::get('/card-requests/{id}', [CardActivationController::class, 'adminShow'])->name('card.review');

            // Approve Request
            Route::post('/card-requests/{id}/approve', [CardActivationController::class, 'approve'])->name('card.approve');

            // Reject Request
            Route::post('/card-requests/{id}/reject', [CardActivationController::class, 'reject'])->name('card.reject');

            // deposit routes
            Route::get('/deposits', [TransactionController::class, 'adminViewDeposits'])->name('deposit.view');
            Route::post('/deposit', [TransactionController::class, 'admin_update'])->name('deposit.update');

            Route::put('/transaction/approve', [TransactionController::class, 'approve'])->name('transaction.approve');
            Route::put('/transaction/decline', [TransactionController::class, 'decline'])->name('transaction.decline');


            Route::get('/kyc', [KycController::class, 'adminIndex'])->name('kyc.index');
            Route::get('/kyc/{id}', [KycController::class, 'adminShow'])->name('kyc.show');
            Route::post('/kyc/{id}/approve', [KycController::class, 'approve'])->name('kyc.approve');
            Route::post('/kyc/{id}/reject', [KycController::class, 'reject'])->name('kyc.reject');

            // payment options
            Route::resource('/payment-options', PaymentOptionController::class);

            // 1. Transaction List (The Index Page)
            Route::get('/transactions', [App\Http\Controllers\Admin\TransactionController::class, 'index'])->name('admin.transactions');

            // 2. Generic Update (Used by the Modal)
            Route::put('/transactions/{id}', [App\Http\Controllers\Admin\TransactionController::class, 'update'])->name('admin.transactions.update');

            Route::put('/transactions/{id}/billing', [App\Http\Controllers\Admin\TransactionController::class, 'updateBilling'])->name('transactions.billing');

            Route::get('/settings', [App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('settings.index');
            Route::post('/settings', [App\Http\Controllers\Admin\SettingsController::class, 'update'])->name('settings.update');

            // trades
            Route::get('/trades', [TradeController::class, 'admin_view_trades'])->name('trades.view');
            Route::put('/trades/close', [TradeController::class, 'admin_update_trade'])->name('trade.close');

            // **START OF ADMIN INVESTMENT CHANGES**
            // Admin panel for Staking Investments (from Investment model)
            Route::get('/investments', [InvestmentController::class, 'admin_view_investments'])->name('investments.view');
            Route::put('/investments', [InvestmentController::class, 'admin_update_investment'])->name('investment.update');

            // Admin panel for Fixed Investment Plan Definitions (STARTER, SILVER, etc.)
            // Replaces: Route::resource('investment-plans', InvestmentPlanController::class);
            Route::resource('investment-plans', AdminInvestmentPlanController::class)->except(['show']);

            // Admin panel for User Fixed Investment Enrollments
            Route::get('/user-fixed-investments', [AdminUserFixedInvestmentController::class, 'index'])->name('user-fixed-investments.index');
            Route::put('/user-fixed-investments/{userFixedInvestment}/disburse', [AdminUserFixedInvestmentController::class, 'disburse'])->name('user-fixed-investments.disburse');
            Route::put('/user-fixed-investments/{userFixedInvestment}/cancel', [AdminUserFixedInvestmentController::class, 'cancel'])->name('user-fixed-investments.cancel');
            // **END OF ADMIN INVESTMENT CHANGES**

            Route::resource('coins', CoinController::class);

            Route::get('/claimed-shares', [SharesController::class, 'admin_view_claimed_shares'])->name('claimed_shares.view');
            Route::put('/claimed-shares/{id}/approve', [SharesController::class, 'approveClaim'])->name('claimed_shares.approve');
            Route::put('/claimed-shares/{claim}/decline', [SharesController::class, 'declineClaim'])->name('claimed_shares.decline');


            // refunds
            Route::get('/refunds', [RefundController::class, 'admin_view_refunds'])->name('refunds.view');
            Route::put('/refunds', [RefundController::class, 'admin_update_refund'])->name('refund.update');

            // withdrawals routes
            Route::get('/withdrawals', [TransactionController::class, 'adminViewWithdrawals'])->name('withdrawal.view');
            Route::post('/withdrawal', [TransactionController::class, 'admin_update'])->name('withdrawal.update');


            // user mgt
            Route::get('/users', [UserController::class, 'admin_view_users'])->name('users.view');
            // Route::post('/deposit', [UserController::class, 'admin_update'])->name('deposit.update');
            Route::put('/user/approve', [UserController::class, 'approve_kyc'])->name('user.approve');
            Route::put('/user/decline', [UserController::class, 'decline_kyc'])->name('user.decline');
            Route::put('/user/suspend', [UserController::class, 'suspend_user'])->name('user.suspend');
            Route::put('/user/reactivate', [UserController::class, 'reactivate_user'])->name('user.reactivate');
            Route::put('/user/deactivate', [UserController::class, 'deactivate_user'])->name('user.deactivate');

            Route::get('/user/wallet/{user}', [UserController::class, 'admin_view_user_wallets'])->name('user.wallets');
            Route::get('/user/topup-wallet-view/{wallet}', [UserController::class, 'admin_view_user_wallet_topup'])->name('user.wallet.topup.view');
            Route::put('/user/topup-wallet/{wallet}', [UserController::class, 'admin_view_user_wallet_topup'])->name('user.wallet.topup');
            // Route::put('/user/topup-wallet/', [UserController::class, 'admin_view_user_wallet_topup'])->name('user.wallet.topup');

            // Signal Management
            Route::resource('signals', AdminSignalController::class); // Assumes index, store, update, destroy

            // Signal Subscriptions Management
            Route::get('/signal-subscriptions', [AdminUserSignalSubscriptionController::class, 'index'])->name('signal-subscriptions.index');
            // Route::put('/admin/signal-subscriptions/{subscription}/cancel', [AdminUserSignalSubscriptionController::class, 'cancel'])->name('signal-subscriptions.cancel'); // Example action

            // Expert Trader Management
            Route::resource('expert-traders', AdminExpertTraderController::class); // Assumes index, store, update, destroy

            Route::resource('stocks', AdminStockController::class)->except(['show', 'create']);

            // protect data
            // route to view protected files
            Route::get('/file/{filename}', function ($filename) {
                $filePath = storage_path('app/private/uploads/' . $filename);

                if (file_exists($filePath)) {
                    return response()->file($filePath);
                    // return Storage::disk('private')->temporaryUrl($filePath, now()->addMinutes(30));
                } else {
                    return abort(404, 'File not found');
                }
            })->name('file');

            // !not working for now but still need it to triger the rest
            Route::get('/claim_file/{filename}', function ($filename) {

                $filePath = storage_path('app/private/' . $filename);
                // dd($filePath);
                if (file_exists($filePath)) {
                    return response()->file($filePath);
                    // return Storage::disk('private')->temporaryUrl($filePath, now()->addMinutes(30));
                } else {
                    return abort(404, 'File not found');
                }
            })->where('filename', '[a-z\_\/]+')->name('claim_file');

            // Route::get('/claim_file/uploads/{filetype}/{filename}', function ($filetype, $filename) {
            //     $filePath = storage_path('app/private/uploads/'.$filetype.'/' . $filename);
            //     // dd($filePath);

            //     if (file_exists($filePath)) {
            //         return response()->file($filePath);
            //     } else {
            //         return abort(404, 'File not found');
            //     }
            // });

            // referral
            Route::resource('/referrals', ReferralController::class);
            // Route::get('/referrals', [ReferralController::class, 'index'])->name('referrals.index');
            // Route::put('/referrals/{referral}', [ReferralController::class, 'update'])->name('referrals.update');

            Route::get('expert-trader/subscriptions/{expertTrader?}', [AdminExpertTraderController::class, 'subscriptions'])->name('expert-traders.subscriptions');

            Route::post('/users/{user}/signin-as', [UserController::class, 'signInAs'])->name('loginAsUser');
        });
    });


});


// dev routes
Route::prefix('/dev-route')->group(function () {

    Route::get('/clear-cache', function () {
        Artisan::call('cache:clear');
        return 'Cache cleared';
    })->name('dev.clear.cache');

    Route::get('/clear-route', function () {
        Artisan::call('route:clear');
        return 'Route cache cleared';
    })->name('dev.clear.route');

    Route::get('/clear-config', function () {
        Artisan::call('config:clear');
        return 'Config cache cleared';
    })->name('dev.clear.config');

    Route::get('/clear-view', function () {
        Artisan::call('view:clear');
        return 'View cache cleared';
    })->name('dev.clear.view');

    Route::get('/optimize', function () {
        Artisan::call('optimize');
        return 'Application optimized';
    })->name('dev.optimize');

    Route::get('/optimize-clear', function () {
        Artisan::call('optimize:clear');
        return 'Optimized cache cleared';
    })->name('dev.optimize.clear');

    Route::get('/migrate-fresh-seed', function () {
        Artisan::call('migrate:fresh --seed');
        return 'Database migrated, fresh, and seeded';
    })->name('dev.migrate.fresh.seed');

    Route::get('/composer-dump-autoload', function () {
        shell_exec('composer dump-autoload'); // Using shell_exec for composer
        return 'Composer dump-autoload executed';
    })->name('dev.composer.dump.autoload');

    // clear all
    Route::get('/clear-all', function () {
        Artisan::call('cache:clear');
        Artisan::call('route:clear');
        Artisan::call('config:clear');
        Artisan::call('view:clear');
        Artisan::call('optimize:clear'); // Clear before optimize
        // Artisan::call('optimize');

        return 'All caches cleared and application optimized';
    })->name('dev.clear.all');

});

require __DIR__.'/auth.php';
