<x-app-layout>
    <section class="py-8 antialiased md:py-16">
        <div class="mx-auto max-w-screen-xl px-4 2xl:px-0">
            <div class="mx-auto max-w-5xl">
                <h1 class="text-xl font-semibold text-white sm:text-2xl mt-10">Stake</h1>

                <div class="mt-6 sm:mt-8 lg:flex lg:items-start lg:gap-12">
                    <form action="" method="POST" class="w-full rounded-lg border border-gray-700 bg-[#131319] p-4 shadow-sm sm:p-6 lg:p-8">
                        @csrf
                        <div class="mb-6 grid grid-cols-1 gap-4">
                            <div>
                                <label for="period" class="mb-2 block text-sm font-medium text-gray-300"> Stake Period (days)* </label>
                                <input type="number" id="period" name="period" min="1"
                                       class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:border-primary-500 focus:ring-primary-500"
                                       placeholder="Enter Period in Days" required value="{{ request()->query('days') ?? '' }}" />
                            </div>
                            <div>
                                <label for="amount" class="mb-2 block text-sm font-medium text-gray-300">
                                    Stake Amount (<span id="currency_code_display">{{ request()->query('code') ?? $coins[0]->code }}</span>)*
                                </label>
                                <input type="number" step="any" id="amount" name="amount"
                                       class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:border-primary-500 focus:ring-primary-500"
                                       placeholder="Enter Amount" required value="{{ request()->query('amt') ?? '' }}" />
                                <small class="mt-1 block text-gray-400">
                                    Max: <span id="max_stake_balance" class="font-semibold">{{ rtrim(rtrim(number_format($coins[0]->authWalletCoin->balance ?? 0, 18, '.', ''), '0'), '.') }}</span>
                                </small>
                            </div>

                            <div>
                                <label for="currency_option" class="mb-2 block text-sm font-medium text-gray-300"> Currency Option* </label>
                                <select id="currency_option" name="option"
                                        class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500 required">
                                    @foreach($coins as $option)
                                        @if($option->stake_apr > 0)
                                            <option value="{{ $option->id }}"
                                                    data-code="{{ $option->code }}"
                                                    data-balance="{{ $option->authWalletCoin->balance ?? 0 }}"
                                                    @if(request()->query('code') && request()->query('code') === $option->code) selected @endif
                                                    class="capitalize">
                                                {{ $option->name }} ({{ $option->code }})
                                            </option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <button type="submit" id="submit_btn"
                                class="w-full text-white bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:ring-primary-300 font-bold py-3 px-4 rounded-lg mt-6 transition-colors duration-200">
                            {{ __('Stake') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <script>
        const currencyOptionSelect = document.getElementById('currency_option');
        const currencyCodeDisplay = document.getElementById('currency_code_display');
        const maxStakeBalance = document.getElementById('max_stake_balance');
        const stakeAmountInput = document.getElementById('amount');
        const submitBtn = document.getElementById('submit_btn');

        // Store coin data from PHP for easy JavaScript access
        const coinsData = @json($coins);

        function updateFormBasedOnSelectedCoin() {
            const selectedOption = currencyOptionSelect.options[currencyOptionSelect.selectedIndex];
            const selectedCoinId = selectedOption.value;

            // Find the full coin object from the coinsData array
            const currentCoin = coinsData.find(coin => coin.id == selectedCoinId);

            if (currentCoin) {
                const balance = currentCoin.auth_wallet_coin ? currentCoin.auth_wallet_coin.balance : 0;
                const code = currentCoin.code;

                currencyCodeDisplay.textContent = code;
                maxStakeBalance.textContent = balance.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 8 });
                stakeAmountInput.max = balance;

                if (balance <= 0) {
                    submitBtn.textContent = "Can't Stake";
                    submitBtn.disabled = true;
                    submitBtn.classList.add('opacity-50', 'cursor-not-allowed');
                    submitBtn.classList.remove('hover:bg-primary-700'); // Remove hover effect when disabled
                } else {
                    submitBtn.textContent = "STAKE";
                    submitBtn.disabled = false;
                    submitBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                    submitBtn.classList.add('hover:bg-primary-700');
                }
            } else {
                // Handle case where no coin is selected or data is missing
                currencyCodeDisplay.textContent = '';
                maxStakeBalance.textContent = '0.00';
                stakeAmountInput.max = 0;
                submitBtn.textContent = "Can't Stake";
                submitBtn.disabled = true;
                submitBtn.classList.add('opacity-50', 'cursor-not-allowed');
                submitBtn.classList.remove('hover:bg-primary-700');
            }
        }

        // Event listener for when the currency option changes
        currencyOptionSelect.addEventListener('change', updateFormBasedOnSelectedCoin);

        // Initial call to set the correct values on page load
        document.addEventListener('DOMContentLoaded', updateFormBasedOnSelectedCoin);
    </script>

    @if (session('success'))
        <div id="success-alert-modal" class="fixed inset-0 bg-[#000] bg-opacity-75 flex items-center justify-center z-50 p-4" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="bg-green-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-green-600">
                <div class="text-center text-white mb-6">
                    <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h2 class="mt-4 text-3xl font-bold">Well Done!</h2>
                    <p class="mt-2">Your stake has been created successfully!</p>
                    <p class="mt-2 text-xl">Stake ID: <span class="font-semibold">{{ session('transaction_id') }}</span></p>
                </div>
                <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                    <a href="/stake" class="w-full sm:w-auto px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200 text-center">Stake Again</a>
                    <a href="/wallet" class="w-full sm:w-auto px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200 text-center">Go To Wallet</a>
                </div>
            </div>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const modal = document.getElementById('success-alert-modal');
                if (modal) {
                    modal.classList.remove('hidden');
                }
            });
        </script>
    @endif
</x-app-layout>
