<x-app-layout>
    <section class="p-4 sm:p-6 lg:p-8">
        <div class="mx-auto max-w-full">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
                <h1 class="text-2xl font-semibold text-white">My Signals</h1>
                <div class="mt-2 sm:mt-0">
                    <a href="{{ route('signals.index') }}"
                       class="inline-flex items-center px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-lg text-sm font-semibold transition-colors duration-200">
                        <svg class="mr-2 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 15l-3-3m0 0l3-3m-3 3h8M3 12a9 9 0 1118 0 9 9 0 01-18 0z"></path>
                        </svg>
                        Browse All Signals
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="px-4 sm:px-6 lg:px-8">
        <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
            @if($subscriptions->isEmpty())
                <div class="p-8 text-center text-gray-400 text-lg">
                    You haven't subscribed to any signals yet.
                    <div class="mt-4">
                        <a href="{{ route('signals.index') }}" class="inline-block px-6 py-3 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">
                            Explore Signals
                        </a>
                    </div>
                </div>
            @else
                <div class="overflow-x-auto">
                    <table id="mySignalsTable" class="min-w-full divide-y divide-gray-700">
                        <thead class="bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Signal Name</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Start Date</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">End Date</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Paid Price</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Progress</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Status</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-700">
                            @foreach ($subscriptions as $subscription)
                            <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white">{{ $subscription->signal->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $subscription->start_date->format('M d, Y') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $subscription->end_date->format('M d, Y') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">${{ number_format($subscription->paid_price, 2) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                    <div class="w-24 bg-gray-600 rounded-full h-2.5 my-1">
                                        <div class="bg-primary-500 h-2.5 rounded-full" style="width: {{ $subscription->progress_percentage }}%"></div>
                                    </div>
                                    <span class="text-xs">{{ $subscription->remaining_days }} days left</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <span class="px-2 py-1 rounded-full text-xs font-semibold
                                        @if($subscription->status === 'active') bg-green-600 text-white
                                        @elseif($subscription->status === 'expired') bg-red-600 text-white
                                        @else bg-gray-500 text-white @endif">
                                        {{ ucfirst($subscription->status) }}
                                    </span>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </section>
</x-app-layout>
