<x-app-layout>
    <main class="flex-1 overflow-y-auto bg-[#000] p-4 sm:p-6 lg:p-8">

        <div class="mb-8">
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-white mb-2">Dashboard Overview</h1>
                    <div class="flex flex-wrap items-center gap-2">
                        @auth
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-primary-600 text-white">
                            Welcome {{ Auth::user()->firstname }} {{ Auth::user()->lastname }}
                        </span>
                        @endauth
                        <span class="text-gray-400 text-sm">Your financial hub at a glance.</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
            {{-- Total Account Balance --}}
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="flex items-center justify-center h-12 w-12 rounded-full bg-primary-600 text-white">
                            <svg data-lucide="banknote" class="w-6 h-6"></svg>
                        </div>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-400 truncate">Total Account Balance</dt>
                            <dd class="text-2xl font-bold text-white">
                                ${{ number_format(Auth::user()->wallet->totalBalance ?? 0, 2) }}
                            </dd>
                            <dd class="text-sm text-green-400 mt-1 flex items-center">
                                <svg data-lucide="trending-up" class="w-4 h-4 mr-1"></svg>
                                +12.5% from last month {{-- Placeholder, replace with actual data --}}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>

            {{-- Available for Trade/Withdraw --}}
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="flex items-center justify-center h-12 w-12 rounded-full bg-blue-600 text-white">
                            <svg data-lucide="wallet" class="w-6 h-6"></svg>
                        </div>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-400 truncate">Available for Trade/Withdraw</dt>
                            <dd class="text-2xl font-bold text-white">
                                ${{ number_format(Auth::user()->wallet->balance ?? 0, 2) }}
                            </dd>
                            <dd class="text-sm text-gray-400 mt-1">Ready for trading & withdrawals</dd>
                        </dl>
                    </div>
                </div>
            </div>

            {{-- Total Staked Value --}}
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="flex items-center justify-center h-12 w-12 rounded-full bg-yellow-600 text-white">
                            <svg data-lucide="piggy-bank" class="w-6 h-6"></svg>
                        </div>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-400 truncate">Total Staked Value</dt>
                            <dd class="text-2xl font-bold text-white">
                                ${{ number_format($total_staked ?? 0, 2) }}
                            </dd>
                            <dd class="text-sm text-green-400 mt-1">
                                <a href="/portfolio" class="inline-flex items-center hover:underline">
                                    <svg data-lucide="eye" class="w-4 h-4 mr-1"></svg>
                                    View Portfolio
                                </a>
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 xl:grid-cols-4 gap-6">
            <div class="xl:col-span-3">
                <div class="bg-[#131319] rounded-lg border border-gray-700 p-6">
                    <div class="mb-4">
                        <h3 class="text-lg font-semibold text-white">Current Market Trends</h3>
                        <p class="text-sm text-gray-400">Track major indices, futures, and forex.</p>
                    </div>

                    <div class="bg-[#000] rounded-lg overflow-hidden">
                        <div class="tradingview-widget-container">
                            <div class="tradingview-widget-container__widget"></div>
                            <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-market-overview.js" async>
                            {
                                "colorTheme": "dark",
                                "dateRange": "12M",
                                "showChart": true,
                                "locale": "en",
                                "largeChartUrl": "",
                                "isTransparent": false,
                                "showSymbolLogo": true,
                                "showFloatingTooltip": false,
                                "width": "100%",
                                "height": "400",
                                "plotLineColorGrowing": "rgba(41, 98, 255, 1)",
                                "plotLineColorFalling": "rgba(41, 98, 255, 1)",
                                "gridLineColor": "rgba(42, 46, 57, 0)",
                                "scaleFontColor": "rgba(209, 212, 220, 1)",
                                "belowLineFillColorGrowing": "rgba(41, 98, 255, 0.12)",
                                "belowLineFillColorFalling": "rgba(41, 98, 255, 0.12)",
                                "belowLineFillColorGrowingBottom": "rgba(41, 98, 255, 0)",
                                "belowLineFillColorFallingBottom": "rgba(41, 98, 255, 0)",
                                "symbolActiveColor": "rgba(41, 98, 255, 0.12)",
                                "tabs": [
                                    {
                                        "title": "Indices",
                                        "symbols": [
                                            {"s": "FOREXCOM:SPXUSD", "d": "S&P 500 Index"},
                                            {"s": "OTC:QOIL", "d": "Quest Oil"},
                                            {"s": "OTC:BPAQF", "d": "BP Plc"},
                                            {"s": "NYSE:XOM", "d": "Exxon Mobil"},
                                            {"s": "NYSE:CVX", "d": "Chevron Corp"},
                                            {"s": "NYSE:TTE", "d": "Total Energies"}
                                        ]
                                    },
                                    {
                                        "title": "Futures",
                                        "symbols": [
                                            {"s": "CME_MINI:ES1!", "d": "S&P 500"},
                                            {"s": "CME:6E1!", "d": "Euro"},
                                            {"s": "COMEX:GC1!", "d": "Gold"},
                                            {"s": "NYMEX:CL1!", "d": "WTI Crude Oil"},
                                            {"s": "NYMEX:NG1!", "d": "Gas"},
                                            {"s": "CBOT:ZC1!", "d": "Corn"}
                                        ]
                                    },
                                    {
                                        "title": "Forex",
                                        "symbols": [
                                            {"s": "FX:EURUSD", "d": "EUR to USD"},
                                            {"s": "FX:GBPUSD", "d": "GBP to USD"},
                                            {"s": "FX:USDJPY", "d": "USD to JPY"},
                                            {"s": "FX:USDCHF", "d": "USD to CHF"},
                                            {"s": "FX:AUDUSD", "d": "AUD to USD"},
                                            {"s": "FX:USDCAD", "d": "USD to CAD"}
                                        ]
                                    }
                                ]
                            }
                            </script>
                        </div>
                    </div>
                </div>
            </div>

            <div class="xl:col-span-1 space-y-6">
                <div class="bg-[#131319] rounded-lg border border-gray-700 p-6 max-w-md mx-auto xl:max-w-none">
                    <h3 class="text-lg font-semibold text-white mb-4">Quick Actions</h3>
                    <div class="grid grid-cols-2 gap-4">
                        <a href="/deposit" class="flex flex-col items-center justify-center p-3 rounded-lg bg-primary-600 hover:bg-primary-700 text-white text-sm font-medium transition-colors duration-200 group">
                            <svg data-lucide="download" class="w-6 h-6 mb-1 group-hover:scale-110 transition-transform duration-200"></svg>
                            Deposit
                        </a>
                        <a href="/trade" class="flex flex-col items-center justify-center p-3 rounded-lg bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium transition-colors duration-200 group">
                            <svg data-lucide="line-chart" class="w-6 h-6 mb-1 group-hover:scale-110 transition-transform duration-200"></svg>
                            Trade
                        </a>
                        <a href="/stake" class="flex flex-col items-center justify-center p-3 rounded-lg bg-yellow-600 hover:bg-yellow-700 text-white text-sm font-medium transition-colors duration-200 group">
                            <svg data-lucide="piggy-bank" class="w-6 h-6 mb-1 group-hover:scale-110 transition-transform duration-200"></svg>
                            Stake
                        </a>
                        <a href="/withdraw" class="flex flex-col items-center justify-center p-3 rounded-lg bg-red-600 hover:bg-red-700 text-white text-sm font-medium transition-colors duration-200 group">
                            <svg data-lucide="upload" class="w-6 h-6 mb-1 group-hover:scale-110 transition-transform duration-200"></svg>
                            Withdraw
                        </a>
                        {{-- New: Signals shortcut --}}
                        <a href="{{ route('signals.index') }}" class="flex flex-col items-center justify-center p-3 rounded-lg bg-indigo-600 hover:bg-indigo-700 text-white text-sm font-medium transition-colors duration-200 group">
                            <svg data-lucide="bell" class="w-6 h-6 mb-1 group-hover:scale-110 transition-transform duration-200"></svg>
                            Signals
                        </a>
                        {{-- New: CopyTrading shortcut --}}
                        <a href="{{ route('copytrading.index') }}" class="flex flex-col items-center justify-center p-3 rounded-lg bg-teal-600 hover:bg-teal-700 text-white text-sm font-medium transition-colors duration-200 group">
                            <svg data-lucide="copy-check" class="w-6 h-6 mb-1 group-hover:scale-110 transition-transform duration-200"></svg>
                            CopyTrade
                        </a>
                    </div>
                </div>

                <div class="bg-[#131319] rounded-lg border border-gray-700 p-6 max-w-md mx-auto xl:max-w-none">
                    <h3 class="text-lg font-semibold text-white mb-4">Recent Activity</h3>
                    @if (Auth::user()->recentTransactions->isNotEmpty())
                    <ul class="space-y-4">
                        @foreach (Auth::user()->recentTransactions as $transaction)
                        <li class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="flex-shrink-0 w-2 h-2 rounded-full
                                    @if($transaction->type === 'deposit') bg-green-500
                                    @elseif($transaction->type === 'withdrawal') bg-red-500
                                    @elseif($transaction->type === 'trade') bg-blue-500
                                    @elseif($transaction->type === 'investment') bg-yellow-500
                                    @elseif($transaction->type === 'signal_subscription') bg-purple-500 {{-- New color for signals --}}
                                    @elseif($transaction->type === 'copy_trade') bg-teal-500 {{-- New color for copy trade --}}
                                    @else bg-gray-500 @endif">
                                </div>
                                <div>
                                    <p class="text-white text-sm font-medium capitalize">
                                        @if($transaction->type === 'signal_subscription')
                                            Signal: {{ Str::limit($transaction->signal_name, 15) }}
                                        @elseif($transaction->type === 'copy_trade')
                                            Copy: {{ Str::limit($transaction->expert_name, 15) }}
                                        @else
                                            {{ $transaction->type }}
                                        @endif
                                    </p>
                                    <p class="text-gray-400 text-xs">{{ $transaction->created_at->diffForHumans() }}</p>
                                </div>
                            </div>
                            <span class="font-semibold text-sm
                                @if(in_array($transaction->type, ['deposit', 'signal_subscription']) || ($transaction->type === 'trade' && $transaction->outcome === 'profit') || ($transaction->type === 'investment' && $transaction->status_id == 4) || ($transaction->type === 'copy_trade' && $transaction->pnl >= 0)) text-green-400
                                @elseif($transaction->type === 'withdrawal' || ($transaction->type === 'trade' && $transaction->outcome === 'loss') || ($transaction->type === 'copy_trade' && $transaction->pnl < 0)) text-red-400
                                @else text-gray-400 @endif">
                                @if($transaction->type === 'withdrawal') -${{ number_format($transaction->amount, 2) }}
                                @elseif($transaction->type === 'copy_trade')
                                    @if($transaction->pnl >= 0) + @endif ${{ number_format($transaction->pnl, 2) }} (P&L)
                                @else ${{ number_format($transaction->amount, 2) }} @endif
                            </span>
                        </li>
                        @endforeach
                    </ul>
                    <div class="mt-6 text-center">
                        <a href="/trade-history" class="text-primary-400 hover:underline text-sm font-medium">View All Transactions</a>
                    </div>
                    @else
                    <p class="text-gray-400 text-sm text-center">No recent activity.</p>
                    @endif
                </div>
            </div>
        </div>
    </main>
</x-app-layout>
