<x-app-layout>
    <section class="p-4 sm:p-6 lg:p-8">
        <div class="mx-auto max-w-full">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
                <h1 class="text-2xl font-semibold text-white">My Replications</h1>
                <div class="mt-2 sm:mt-0">
                    <a href="{{ route('copytrading.index') }}"
                       class="inline-flex items-center px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-lg text-sm font-semibold transition-colors duration-200">
                        <svg class="mr-2 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 15l-3-3m0 0l3-3m-3 3h8M3 12a9 9 0 1118 0 9 9 0 01-18 0z"></path>
                        </svg>
                        Browse Expert Traders
                    </a>
                </div>
            </div>
        </div>
    </section>

    @if (session('success'))
        <x-toast-success>{{ session('success') }}</x-toast-success>
    @endif
    @if (session('error'))
        <x-toast-danger>{{ session('error') }}</x-toast-danger>
    @endif

    <section class="px-4 sm:px-6 lg:px-8">
        <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
            @if($replications->isEmpty())
                <div class="p-8 text-center text-gray-400 text-lg">
                    You are not currently replicating any expert traders.
                    <div class="mt-4">
                        <a href="{{ route('copytrading.index') }}" class="inline-block px-6 py-3 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">
                            Discover Expert Traders
                        </a>
                    </div>
                </div>
            @else
                <div class="overflow-x-auto">
                    <table id="myReplicationsTable" class="min-w-full divide-y divide-gray-700">
                        <thead class="bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Expert</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Allocated Amount</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Current P&L</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Revenue Share</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Started On</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-700">
                            @foreach ($replications as $replication)
                            <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white">{{ $replication->expertTrader->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">${{ number_format($replication->allocated_amount, 2) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <span class="font-semibold @if($replication->current_pnl >= 0) text-green-400 @else text-red-400 @endif">
                                        ${{ number_format($replication->current_pnl, 2) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                    {{ number_format($replication->expertTrader->revenue_share_percentage, 2) }}%
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                    {{ $replication->created_at->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <span class="px-2 py-1 rounded-full text-xs font-semibold
                                        @if($replication->status === 'active') bg-green-600 text-white
                                        @elseif($replication->status === 'paused') bg-yellow-600 text-white
                                        @else bg-red-600 text-white @endif">
                                        {{ ucfirst($replication->status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    @if($replication->status === 'active' || $replication->status === 'paused')
                                        <button type="button" onclick="openStopReplicationModal({{ $replication->id }}, '{{ $replication->expertTrader->name }}')"
                                                class="px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Stop</button>
                                        {{-- Add Pause/Resume buttons here if you implement those statuses --}}
                                    @else
                                        <span class="text-gray-500 text-xs">No actions</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </section>

    {{-- Stop Replication Modal (Single Instance) --}}
    <x-modal id="stop-replication-modal">
        <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
            <div class="text-white mb-6">
                <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2A9 9 0 111 10a9 9 0 0118 0z"></path>
                </svg>
                <h2 class="mt-4 text-2xl font-bold">Stop Replication</h2>
                <p class="mt-2 text-white">Are you sure you want to stop replicating <span id="stopModalExpertName" class="font-semibold"></span>?</p>
                <p class="mt-1 text-sm text-white">This will close all open positions and return funds to your wallet.</p>
            </div>
            <form action="" method="POST" id="stopReplicationForm">
                @csrf
                @method('PUT')
                <input type="hidden" name="replication_id" id="stopReplicationId">
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Stop</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('stop-replication-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    <script>
        // Stop Replication Modal elements
        const stopReplicationModal = document.getElementById('stop-replication-modal');
        const stopReplicationForm = document.getElementById('stopReplicationForm');
        const stopReplicationId = document.getElementById('stopReplicationId');
        const stopModalExpertName = document.getElementById('stopModalExpertName');

        function openStopReplicationModal(replicationId, expertName) {
            stopReplicationId.value = replicationId;
            stopModalExpertName.textContent = expertName;
            stopReplicationForm.action = `/copytrading/stop/${replicationId}`; // Set dynamic action URL
            openModal('stop-replication-modal');
        }
    </script>
</x-app-layout>
