<x-app-layout>
    <section class="p-4 sm:p-6 lg:p-8">
        <div class="mx-auto max-w-full">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
                <h1 class="text-2xl font-semibold text-white">Expert Traders</h1>
                <div class="mt-2 sm:mt-0">
                    <a href="{{ route('copytrading.my-copytrades') }}"
                       class="inline-flex items-center px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-lg text-sm font-semibold transition-colors duration-200">
                        My Replications
                        <svg data-lucide="arrow-right" class="ml-2 w-4 h-4"></svg>
                    </a>
                </div>
            </div>
        </div>
    </section>

    @if (session('success'))
        <x-toast-success>{{ session('success') }}</x-toast-success>
    @endif
    @if (session('error'))
        <x-toast-danger>{{ session('error') }}</x-toast-danger>
    @endif

    <section class="px-4 sm:px-6 lg:px-8">
        <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
            <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
                <h4 class="text-xl font-semibold text-white">Browse Copy-Trade Plans</h4>
                <div class="mt-4 sm:mt-0 flex items-center gap-4">
                    <input type="text" id="expertSearch" placeholder="Search plans..."
                           class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
                </div>
            </div>

            @if($expertTraders->isEmpty())
                <div class="p-8 text-center text-gray-400 text-lg">
                    No copy-trade plans available at the moment.
                </div>
            @else
                <div id="expertsContainer" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    {{-- Expert Trader cards will be rendered here by JavaScript --}}
                </div>
                {{-- Store expertTraders data in a JS variable for client-side rendering --}}
                <script>
                    // Ensure features are parsed correctly in JS, it comes as a string in Blade.
                    // If features are null, ensure they are empty arrays.
                    const allExpertTradersData = @json($expertTraders->map(function($expert) {
                        $expert->features = $expert->features ?? []; // Ensure it's an array, not null
                        return $expert;
                    }));
                </script>
            @endif

            <div id="paginationControls" class="flex justify-between items-center mt-6">
                <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
                <div id="pageNumbers" class="flex gap-2">
                    </div>
                <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
            </div>
        </div>
    </section>

    {{-- Replicate Trades Modal (Single Instance) --}}
    <x-modal id="replicate-trades-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-gray-700">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Replicate <span id="modalPlanName"></span></h2>
                <p class="text-sm text-gray-400 mt-1">Revenue Share: <span id="modalRevenueShare" class="font-semibold text-red-400"></span>% of profits</p>
                <p class="text-sm text-gray-400">Expected ROI: <span id="modalExpectedRoi" class="font-semibold text-green-400"></span>%</p>
            </div>
            <form action="{{ route('copytrading.start') }}" method="POST">
                @csrf
                <input type="hidden" name="expert_trader_id" id="modalExpertId">

                <div class="space-y-4 text-left mb-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Investment Range</label>
                        <p class="text-white font-bold text-lg mb-2">
                            $<span id="modalMinInvestment"></span> - $<span id="modalMaxInvestment"></span>
                        </p>
                    </div>
                    <div>
                        <label for="modalAllocatedAmount" class="block text-sm font-medium text-gray-300 mb-1">Your Allocated Amount (USD)</label>
                        <input type="number" name="allocated_amount" id="modalAllocatedAmount" step="any" min="1" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        <p class="text-xs text-gray-400 mt-1">Available balance: ${{ number_format(Auth::user()->wallet->balance ?? 0, 2) }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Duration</label>
                        <p class="text-white font-bold text-lg">
                            <span id="modalDurationValue"></span> <span id="modalDurationUnit"></span>
                        </p>
                    </div>
                     <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Risk Level</label>
                        <p class="text-white font-bold text-lg" id="modalRiskLevel"></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Features</label>
                        <ul id="modalFeaturesList" class="list-disc list-inside text-sm text-gray-300 space-y-1 pl-4">
                            {{-- Features will be populated here --}}
                        </ul>
                    </div>
                </div>

                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition-colors duration-200">Start Replicating</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('replicate-trades-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    <script>
        // Modal elements
        const replicateTradesModal = document.getElementById('replicate-trades-modal');
        const modalExpertId = document.getElementById('modalExpertId');
        const modalPlanName = document.getElementById('modalPlanName'); // Updated ID
        const modalRevenueShare = document.getElementById('modalRevenueShare');
        const modalExpectedRoi = document.getElementById('modalExpectedRoi'); // New
        const modalMinInvestment = document.getElementById('modalMinInvestment'); // New
        const modalMaxInvestment = document.getElementById('modalMaxInvestment'); // New
        const modalDurationValue = document.getElementById('modalDurationValue'); // New
        const modalDurationUnit = document.getElementById('modalDurationUnit'); // New
        const modalRiskLevel = document.getElementById('modalRiskLevel'); // New
        const modalFeaturesList = document.getElementById('modalFeaturesList'); // New
        const modalAllocatedAmount = document.getElementById('modalAllocatedAmount');

        // Main content elements for search/pagination
        const expertsContainer = document.getElementById('expertsContainer');
        const expertSearchInput = document.getElementById('expertSearch');
        const prevButton = document.getElementById('prevPage');
        const nextPageButton = document.getElementById('nextPage');
        const pageNumbersContainer = document.getElementById('pageNumbers');

        const itemsPerPage = 9; // Number of expert cards per page
        let currentPage = 1;
        let filteredExperts = []; // Will hold experts filtered by search


        // Function to open the replication modal
        function openReplicateModal(expertData) {
            modalExpertId.value = expertData.id;
            modalPlanName.textContent = expertData.name;
            modalRevenueShare.textContent = expertData.revenue_share_percentage.toFixed(2);
            modalExpectedRoi.textContent = expertData.expected_roi_percentage.toFixed(2);
            modalMinInvestment.textContent = expertData.min_investment_amount.toLocaleString();
            modalMaxInvestment.textContent = expertData.max_investment_amount.toLocaleString();
            modalDurationValue.textContent = expertData.expected_duration_value;
            modalDurationUnit.textContent = expertData.expected_duration_unit + (expertData.expected_duration_value > 1 ? 's' : '');
            modalRiskLevel.textContent = expertData.risk_level;

            // Populate features list
            modalFeaturesList.innerHTML = '';
            if (expertData.features && expertData.features.length > 0) {
                expertData.features.forEach(feature => {
                    if (feature.trim() !== '') {
                        const li = document.createElement('li');
                        li.textContent = feature;
                        modalFeaturesList.appendChild(li);
                    }
                });
            } else {
                const li = document.createElement('li');
                li.textContent = 'No specific features listed.';
                modalFeaturesList.appendChild(li);
            }

            // Set min/max for the allocated amount input based on the plan
            modalAllocatedAmount.min = expertData.min_investment_amount;
            modalAllocatedAmount.max = expertData.max_investment_amount;
            modalAllocatedAmount.value = expertData.min_investment_amount;

            openModal('replicate-trades-modal');
        }

        // Function to render expert cards into the container
        function renderExpertCards() {
            const searchTerm = expertSearchInput.value.toLowerCase();
            filteredExperts = allExpertTradersData.filter(expert => {
                console.log(expert.features.typeOf);
                const expertText = `${expert.name} ${expert.email} ${expert.description} ${expert.expected_roi_percentage} ${expert.min_investment_amount} ${expert.max_investment_amount} ${expert.risk_level} ${expert.features.join(' ')}`.toLowerCase();
                return expertText.includes(searchTerm);
            });

            const totalPages = Math.ceil(filteredExperts.length / itemsPerPage);

            // Adjust current page if it's out of bounds after filtering
            if (currentPage > totalPages && totalPages > 0) {
                currentPage = totalPages;
            } else if (totalPages === 0 && searchTerm !== "") {
                currentPage = 1; // No matching results
            } else if (totalPages === 0 && searchTerm === "") {
                currentPage = 1; // No experts at all
            }

            const start = (currentPage - 1) * itemsPerPage;
            const end = start + itemsPerPage;
            const paginatedExperts = filteredExperts.slice(start, end);

            expertsContainer.innerHTML = ''; // Clear existing cards

            if (paginatedExperts.length === 0) {
                expertsContainer.innerHTML = `
                    <div class="md:col-span-2 lg:col-span-3 p-8 text-center text-gray-400 text-lg">
                        ${searchTerm ? 'No copy-trade plans matching your search.' : 'No copy-trade plans to display.'}
                    </div>
                `;
            } else {
                paginatedExperts.forEach(expert => {
                    const featuresHtml = expert.features && expert.features.length > 0
                        ? expert.features.filter(f => f.trim() !== '').map(f => `<li>${f}</li>`).join('')
                        : '<li>No specific features listed.</li>';

                    const cardDiv = document.createElement('div');
                    cardDiv.className = 'relative bg-gray-700 rounded-lg xp-6 border border-gray-700 shadow-md flex flex-col justify-between transition-all duration-200 hover:border-primary-500 hover:shadow-lg';

                    cardDiv.innerHTML = `
                        <div class="xabsolute top-0 left-0 w-full bg-red-600 text-white text-center py-2 rounded-t-lg text-lg font-bold">
                            ${expert.name}
                        </div>
                        <div class="p-6">
                            <div class="xmt-12 mb-4 space-y-2 w-full text-left">
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Investment Range:</span>
                                    <span class="font-bold text-white text-right">$${expert.min_investment_amount.toLocaleString()} - $${expert.max_investment_amount.toLocaleString()}</span>
                                </div>
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Duration:</span>
                                    <span class="font-bold text-white text-right">${expert.expected_duration_value} ${expert.expected_duration_unit}${expert.expected_duration_value > 1 ? '' : ''}</span>
                                </div>
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Expected ROI:</span>
                                    <span class="font-bold text-green-400 text-right">${expert.expected_roi_percentage.toFixed(2)}% Return</span>
                                </div>
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Risk Level:</span>
                                    <span class="font-bold text-right ${expert.risk_level === 'Low' ? 'text-green-500' : expert.risk_level === 'Medium' ? 'text-yellow-500' : 'text-red-500'}">${expert.risk_level}</span>
                                </div>
                            </div>
                            <div class="w-full text-left mb-4">
                                <span class="font-semibold text-gray-300">Features:</span>
                                <ul class="list-disc list-inside text-sm text-gray-400 pl-4">
                                    ${featuresHtml}
                                </ul>
                            </div>
                            <div class="flex items-center justify-between text-gray-300 text-sm mb-4">
                                <span>Revenue Share:</span>
                                <span class="font-semibold text-red-400">${expert.revenue_share_percentage.toFixed(2)}% of profits</span>
                            </div>
                            <button type="button"
                                onclick="openReplicateModal(${expert})"
                                class="start-replication-btn mt-4 w-full bg-primary-600 hover:bg-primary-700 text-white font-semibold py-3 px-4 rounded-lg transition-colors duration-200">
                                Start Now!
                            </button>
                        </div>
                    `;
                    const startBtn = cardDiv.querySelector('.start-replication-btn');
                    startBtn.addEventListener('click', () => {
                        openReplicateModal(expert);
                    });
                    expertsContainer.appendChild(cardDiv);
                });
                if (typeof lucide !== 'undefined' && lucide.createIcons) {
                    lucide.createIcons();
                }
            }
            updatePaginationControls(totalPages);
        }

        // Function to update pagination buttons and page numbers
        function updatePaginationControls(totalPages) {
            prevButton.disabled = currentPage === 1;
            nextPageButton.disabled = currentPage === totalPages || totalPages === 0;

            pageNumbersContainer.innerHTML = '';
            const maxPageButtons = 5;

            let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
            let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

            if (endPage - startPage + 1 < maxPageButtons) {
                startPage = Math.max(1, endPage - maxPageButtons + 1);
            }

            if (startPage > 1) {
                const ellipsis = document.createElement('span');
                ellipsis.textContent = '...';
                ellipsis.className = 'px-2 text-gray-400';
                pageNumbersContainer.appendChild(ellipsis);
            }

            for (let i = startPage; i <= endPage; i++) {
                const pageButton = document.createElement('button');
                pageButton.textContent = i;
                pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                    i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                }`;
                pageButton.addEventListener('click', () => {
                    currentPage = i;
                    renderExpertCards();
                });
                pageNumbersContainer.appendChild(pageButton);
            }

            if (endPage < totalPages) {
                const ellipsis = document.createElement('span');
                ellipsis.textContent = '...';
                ellipsis.className = 'px-2 text-gray-400';
                pageNumbersContainer.appendChild(ellipsis);
            }
        }

        // Event Listeners for search and pagination
        expertSearchInput.addEventListener('input', () => {
            currentPage = 1;
            renderExpertCards();
        });

        prevButton.addEventListener('click', () => {
            if (currentPage > 1) {
                currentPage--;
                renderExpertCards();
            }
        });

        nextPageButton.addEventListener('click', () => {
            const totalPages = Math.ceil(filteredExperts.length / itemsPerPage);
            if (currentPage < totalPages) {
                currentPage++;
                renderExpertCards();
            }
        });

        // Initial render
        document.addEventListener('DOMContentLoaded', renderExpertCards);
    </script>
</x-app-layout>
