<ul class="space-y-2 text-sm">
    {{-- USERS --}}
    <li>
        <a href="{{ route('admin.users.view') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.users.view*') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="users" class="mr-3 w-5 h-5"></svg>
            Users
        </a>
    </li>

    {{-- CARD MANAGEMENT GROUP --}}
    <li>
        <a href="{{ route('admin.cards') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.cards') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="credit-card" class="mr-3 w-5 h-5"></svg>
            Manage Cards
        </a>
    </li>

    <li>
        <a href="{{ route('admin.card.requests') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.card.requests*') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="inbox" class="mr-3 w-5 h-5"></svg>
            Card Requests
            @php
                $pendingCards = \App\Models\CardActivationRequest::where('status', 'pending')->count();
            @endphp
            @if($pendingCards > 0)
                <span class="ml-auto bg-red-600 text-white text-[10px] font-bold px-2 py-0.5 rounded-full">{{ $pendingCards }}</span>
            @endif
        </a>
    </li>

    {{-- KYC MANAGEMENT --}}
    <li>
        <a href="{{ route('admin.kyc.index') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.kyc.*') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="shield-check" class="mr-3 w-5 h-5"></svg>
            KYC Applications
            @php
                $pendingKyc = \App\Models\User::where('kyc_status', 'pending')->count();
            @endphp
            @if($pendingKyc > 0)
                <span class="ml-auto bg-red-600 text-white text-[10px] font-bold px-2 py-0.5 rounded-full">{{ $pendingKyc }}</span>
            @endif
        </a>
    </li>

    {{-- TRANSACTIONS --}}
    <li>
        <a href="{{ route('admin.admin.transactions') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.admin.transactions*') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="arrow-left-right" class="mr-3 w-5 h-5"></svg>
            Transactions
        </a>
    </li>

    {{-- FINANCE --}}
    <li>
        <a href="{{ route('admin.deposit.view') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.deposit.view') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="download" class="mr-3 w-5 h-5"></svg>
            Deposits
        </a>
    </li>
    <li>
        <a href="{{ route('admin.withdrawal.view') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.withdrawal.view') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="upload" class="mr-3 w-5 h-5"></svg>
            Withdrawals
        </a>
    </li>

    {{-- SETTINGS --}}
    <li>
        <a href="{{ route('admin.personas.index') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.personas.*') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="fingerprint" class="mr-3 w-5 h-5"></svg>
            Branding
        </a>
    </li>
    <li>
        <a href="{{ route('admin.coins.index') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.coins.*') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="coins" class="mr-3 w-5 h-5"></svg>
            Manage Coins
        </a>
    </li>
    <li>
        <a href="{{ route('admin.referrals.index') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.referrals.*') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="share-2" class="mr-3 w-5 h-5"></svg>
            Referrals
        </a>
    </li>
    <li>
        <a href="{{ route('admin.settings.index') }}"
           class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 {{ request()->routeIs('admin.settings.*') ? 'bg-gray-700 text-white' : '' }}">
            <svg data-lucide="settings" class="mr-3 w-5 h-5"></svg>
            Settings
        </a>
    </li>
</ul>
