<x-guest-layout>
    <div class="mb-4 text-sm text-gray-300">
        {{ __('Thanks for signing up! Before getting started, you need to verify your email address. Just click on the verification link we sent to your email. If you didn\'t receive it, we can send you another one.') }}
    </div>

    @if (session('status') == 'verification-link-sent')
        <div class="mb-4 font-medium text-sm text-green-500">
            {{ __('A new verification link has been sent to the email address you provided during registration.') }}
        </div>
    @endif

    <div class="mt-6 space-y-4"> {{-- Added space-y for vertical spacing between forms --}}
        <form method="POST" action="{{ route('verification.send') }}">
            @csrf

            <button type="submit" class="w-full text-white bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:ring-primary-300 font-bold py-3 px-4 rounded-lg transition-colors duration-200">
                {{ __('Resend Verification Email') }}
            </button>
        </form>

        <form method="POST" action="{{ route('logout') }}">
            @csrf

            <button type="submit" class="w-full text-center underline text-sm text-gray-400 hover:text-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 focus:ring-offset-gray-800 py-2"> {{-- Adjusted styling to be a full-width link-button --}}
                {{ __('Log Out') }}
            </button>
        </form>
    </div>
</x-guest-layout>
