<x-app-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">

        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
            <h4 class="text-2xl font-semibold text-white">Manage User Cards</h4>

            {{-- Search & Filter Form --}}
            <form action="{{ route('admin.cards') }}" method="GET" class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto">
                <select name="status" class="bg-gray-800 text-sm text-white border border-gray-600 rounded-lg px-3 py-2 focus:ring-indigo-500 focus:border-indigo-500">
                    <option value="all">All Statuses</option>
                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                    <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                    <option value="frozen" {{ request('status') == 'frozen' ? 'selected' : '' }}>Frozen</option>
                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                </select>

                <div class="relative">
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search user or last 4 digits..."
                           class="bg-gray-800 text-sm text-white border border-gray-600 rounded-lg pl-10 pr-4 py-2 w-full sm:w-64 focus:ring-indigo-500 focus:border-indigo-500">
                    <svg class="w-4 h-4 text-gray-400 absolute left-3 top-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                </div>

                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white text-sm font-bold px-4 py-2 rounded-lg transition-colors">
                    Filter
                </button>
            </form>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Cardholder</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Card Number</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Balance</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Expiry</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-400 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($cards as $card)
                    <tr class="hover:bg-gray-700 transition-colors">
                        {{-- User --}}
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="h-8 w-8 rounded-full bg-indigo-500/20 flex items-center justify-center text-indigo-400 font-bold text-xs mr-3">
                                    {{ substr($card->user->firstname ?? 'U', 0, 1) }}
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-white">{{ $card->user->firstname ?? 'N/A' }} {{ $card->user->lastname ?? '' }}</div>
                                    <div class="text-xs text-gray-400">{{ $card->user->email ?? 'N/A' }}</div>
                                </div>
                            </div>
                        </td>

                        {{-- Card Number --}}
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="font-mono text-sm text-gray-300">**** **** **** {{ substr($card->card_number, -4) }}</span>
                            <span class="ml-2 text-xs bg-gray-600 text-gray-300 px-1.5 py-0.5 rounded">{{ $card->cvv }}</span>
                        </td>

                        {{-- Balance --}}
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm font-bold text-white">${{ number_format($card->balance, 2) }}</span>
                        </td>

                        {{-- Expiry --}}
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-400">
                            {{ $card->expiry_month }}/{{ substr($card->expiry_year, 2) }}
                        </td>

                        {{-- Status --}}
                        <td class="px-6 py-4 whitespace-nowrap">
                            @php
                                $statusClasses = [
                                    'active' => 'bg-green-100 text-green-800',
                                    'inactive' => 'bg-gray-100 text-gray-800',
                                    'frozen' => 'bg-red-100 text-red-800',
                                    'pending' => 'bg-yellow-100 text-yellow-800',
                                ];
                                $class = $statusClasses[$card->status] ?? 'bg-gray-100 text-gray-800';
                            @endphp
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $class }}">
                                {{ ucfirst($card->status) }}
                            </span>
                        </td>

                        {{-- Actions --}}
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <div class="flex items-center justify-end gap-2">
                                @if($card->status === 'active')
                                    <form action="{{ route('admin.cards.status', $card->id) }}" method="POST" onsubmit="return confirm('Freeze this card? The user will not be able to use it.');">
                                        @csrf @method('PATCH')
                                        <input type="hidden" name="status" value="frozen">
                                        <button type="submit" class="text-red-400 hover:text-red-300 text-xs border border-red-500/30 px-2 py-1 rounded hover:bg-red-500/10 transition">
                                            Freeze
                                        </button>
                                    </form>
                                @elseif($card->status === 'frozen')
                                    <form action="{{ route('admin.cards.status', $card->id) }}" method="POST" onsubmit="return confirm('Unfreeze this card?');">
                                        @csrf @method('PATCH')
                                        <input type="hidden" name="status" value="active">
                                        <button type="submit" class="text-green-400 hover:text-green-300 text-xs border border-green-500/30 px-2 py-1 rounded hover:bg-green-500/10 transition">
                                            Unfreeze
                                        </button>
                                    </form>
                                @endif

                                {{-- Optional: Edit or View Details --}}
                                {{-- <a href="#" class="text-gray-400 hover:text-white"><svg class="w-4 h-4" ...></svg></a> --}}
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-6 py-10 text-center text-gray-500">
                            No cards found matching your filters.
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $cards->appends(request()->query())->links() }}
        </div>
    </div>
</x-app-layout>
