<x-app-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Branding</h4>
                <p class="mt-2 text-gray-400 text-sm">Manage app branding and identity. Only one persona can be active.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <button type="button" onclick="openModal('add-new-persona-modal')"
                        class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">
                    Create New Branding
                </button>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Identity</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Color</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach ($personas as $persona)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200 {{ $persona->is_active ? 'border-l-4 border-green-500' : '' }}">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <div class="h-10 w-10 flex-shrink-0">
                                    <img class="h-10 w-10 rounded-full object-cover bg-gray-800" src="{{ asset('storage/'.$persona->logo_path) }}" alt="">
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-white">{{ $persona->name }}</div>
                                    <div class="text-sm text-gray-400">{{ $persona->tagline ?? 'No tagline' }}</div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center gap-2">
                                <div class="w-6 h-6 rounded-full border border-gray-500" style="background-color: {{ $persona->primary_color }}"></div>
                                <span class="text-sm text-gray-300">{{ $persona->primary_color }}</span>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($persona->is_active)
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                    Active
                                </span>
                            @else
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-600 text-gray-200">
                                    Inactive
                                </span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <div class="flex flex-col sm:flex-row gap-2">
                                @if(!$persona->is_active)
                                <form action="{{ route('admin.personas.activate', $persona->id) }}" method="POST">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" class="px-3 py-1.5 rounded-md text-white bg-green-600 hover:bg-green-700 transition-colors duration-200 text-xs font-medium">
                                        Activate
                                    </button>
                                </form>
                                @endif

                                <button type="button" onclick="openModal('edit-persona-modal-{{ $persona->id }}')"
                                        class="px-3 py-1.5 rounded-md text-white bg-blue-600 hover:bg-blue-700 transition-colors duration-200 text-xs font-medium">Edit</button>

                                @if(!$persona->is_active)
                                <button type="button" onclick="openModal('delete-persona-modal-{{ $persona->id }}')"
                                        class="px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Delete</button>
                                @endif
                            </div>
                        </td>
                    </tr>

                    {{-- Edit Modal --}}
                    <x-modal id="edit-persona-modal-{{ $persona->id }}">
                        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700 max-h-[85vh] overflow-y-auto">
                            <div class="border-b border-gray-700 pb-4 mb-6">
                                <h2 class="text-2xl font-bold text-white">Edit Persona</h2>
                            </div>
                            <form action="{{ route('admin.personas.update', $persona->id) }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="space-y-4 text-left">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-300 mb-1">App Name</label>
                                        <input type="text" name="name" value="{{ $persona->name }}" required
                                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:ring-primary-500">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-300 mb-1">Tagline</label>
                                        <input type="text" name="tagline" value="{{ $persona->tagline }}"
                                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:ring-primary-500">
                                    </div>
                                    <div class="grid grid-cols-2 gap-4">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-300 mb-1">Primary Color</label>
                                            <div class="flex gap-2">
                                                <input type="color" name="primary_color" value="{{ $persona->primary_color }}" class="h-10 w-10 bg-transparent border-0 cursor-pointer">
                                                <input type="text" name="primary_color" value="{{ $persona->primary_color }}" class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="space-y-3">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-300 mb-1">Icon Logo (Favicon/Small)</label>
                                            <input type="file" name="logo" class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary-600 file:text-white hover:file:bg-primary-700"/>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-300 mb-1">Full Logo (Light Mode)</label>
                                            <input type="file" name="logo_with_name" class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary-600 file:text-white hover:file:bg-primary-700"/>
                                            <p class="text-xs text-gray-500 mt-1">Used on light backgrounds.</p>
                                        </div>
                                        {{-- NEW: Dark Mode Logo Input --}}
                                        <div>
                                            <label class="block text-sm font-medium text-gray-300 mb-1">Full Logo (Dark Mode)</label>
                                            <input type="file" name="logo_dark_full" class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary-600 file:text-white hover:file:bg-primary-700"/>
                                            <p class="text-xs text-gray-500 mt-1">Used on dark backgrounds (e.g., Sidebar).</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex justify-end gap-4 mt-6">
                                    <button type="submit" class="px-6 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg">Save Changes</button>
                                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg" onclick="closeModal('edit-persona-modal-{{ $persona->id }}')">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </x-modal>

                    {{-- Delete Modal --}}
                    @if(!$persona->is_active)
                    <x-modal id="delete-persona-modal-{{ $persona->id }}">
                        <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
                            <h2 class="mt-4 text-2xl font-bold text-white">Delete Persona</h2>
                            <p class="mt-2 text-white">Are you sure you want to delete <strong>{{ $persona->name }}</strong>?</p>
                            <form action="{{ route('admin.personas.destroy', $persona->id) }}" method="POST">
                                @csrf @method('DELETE')
                                <div class="flex justify-center gap-4 mt-6">
                                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg">Yes, Delete</button>
                                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg" onclick="closeModal('delete-persona-modal-{{ $persona->id }}')">No</button>
                                </div>
                            </form>
                        </div>
                    </x-modal>
                    @endif

                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    {{-- Add New Modal --}}
    <x-modal id="add-new-persona-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700 max-h-[85vh] overflow-y-auto">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Create New Persona</h2>
            </div>
            <form action="{{ route('admin.personas.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="space-y-4 text-left">
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">App Name</label>
                        <input type="text" name="name" required class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:ring-primary-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Tagline</label>
                        <input type="text" name="tagline" class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:ring-primary-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Primary Color</label>
                        <div class="flex gap-2">
                            <input type="color" name="primary_color" value="#6366f1" class="h-10 w-10 bg-transparent border-0 cursor-pointer">
                            <input type="text" name="primary_color" value="#6366f1" class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white">
                        </div>
                    </div>
                    <div class="space-y-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-1">Icon Logo (Required)</label>
                            <input type="file" name="logo" required class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary-600 file:text-white hover:file:bg-primary-700"/>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-1">Full Logo (Light Mode)</label>
                            <input type="file" name="logo_with_name" class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary-600 file:text-white hover:file:bg-primary-700"/>
                        </div>
                        {{-- NEW: Dark Mode Logo Input --}}
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-1">Full Logo (Dark Mode)</label>
                            <input type="file" name="logo_dark_full" class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary-600 file:text-white hover:file:bg-primary-700"/>
                        </div>
                    </div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg">Create Persona</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg" onclick="closeModal('add-new-persona-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>
</x-app-layout>
