<x-admin-layout>
    <div class="box">
        <div class="box-header">
            <h4 class="font-bold text-3xl">Payment Options</h4>
            <p class="mb-0 subtitle">Manage Pyment Options for deposits and withdrawals.</p>
            <x-primary-button class="mt-5" data-bs-toggle="modal" data-bs-target="#add-new-option">Add New</x-primary-button>
        </div>

        <div class="box-body">
            <div class="table-responsive">
                <table id="deposits" class="text-fade table table-bordered">
                    <thead>
                        <tr class="text-dark">
                            <th>Name</th>
                            <th>Account Info</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($options as $option)
                        <tr class="capitalize">
                            <td>{{$option->name}}</td>
                            <td class="text-dark">{{$option->account_details}}</td>
                            <td class="gap-4">
                                <x-danger-button class="bg-red-700 mr-4 inline-flex " data-bs-toggle="modal" data-bs-target="#confirm-delete-modal-{{$option->id}}" >Delete</x-danger-button>

                                <div id="confirm-delete-modal-{{$option->id}}" class="modal fade" style="background: rgba(0, 0, 0, 0.7);" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content modal-filled bg-danger">
                                            <div class="modal-body p-4">
                                                <div class="text-center">
                                                    <i class="dripicons-checkmark h1"></i>
                                                    <h2 class="mt-2">Are You Sure You Want To Delete?</h2>
                                                    <h2 class="mt-2 text-2xl"></h2>
                                                    <form action="{{ route('admin.payment-options.destroy', $option) }}" method="POST" class="flex item-center justify-center gap-4">
                                                        @csrf
                                                        @method('DELETE')
                                                        <input type="hidden" name="id" value="{{$option->id}}">
                                                        <button type="submit" class="btn btn-light my-2 bg-white">Yes</button>
                                                        <button type="button" class="btn btn-light my-2 bg-white" data-bs-dismiss="modal">No</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <!-- Approval modal -->
            <div id="add-new-option" class="modal fade" style="background: rgba(0, 0, 0, 0.7);" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content modal-filled ">
                        <h2 class="mt-2 modal-title p-2 border-b border-green-500 text-black font-bold text-3xl text-center">Add New Payment Option</h2>
                        <div class="modal-body p-4">
                            <div class="text-center">
                                <i class="dripicons-checkmark h1"></i>
                                <h2 class="my-2 text-2xl"></h2>
                                <form action="{{route('admin.payment-options.store')}}" method="POST">
                                    @csrf
                                    <label for="name" class="text-right">Name of Payment Option</label>
                                    <input type="text" class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-primary-500 focus:ring-primary-500 dark:border-gray-600  dark:placeholder:text-gray-400" name="name" id="name" maxlength="15">
                                    <label for="account_details" class="mt-8 text-right">Account Details</label>
                                    <textarea type="text" class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-primary-500 focus:ring-primary-500 dark:border-gray-600  dark:placeholder:text-gray-400" name="account_details" id="account_details"></textarea>
                                    <input type="hidden" name="id" value="{{$option->id}}">
                                    <div class="flex item-center justify-center gap-4 my-4">
                                        <button type="submit" class="btn my-2 bg-green-700 border border-green-700 text-white" style="background-color: green">Add</button>
                                        <button type="button" class="btn btn-light my-2 bg-gray-300 text-white" data-bs-dismiss="modal">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div><!-- /.modal -->
        </div>
    </div>
    @if (session('success'))
        <x-toast-success>Option Added</x-toast-success>
    @endif
    @if (session('delete_success'))
        <x-toast-danger>Option Deleted</x-toast-danger>
    @endif
</x-admin-layout>
