<x-app-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Investment Plans</h4>
                <p class="mt-2 text-gray-400 text-sm">Manage staking and investment plans for users.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="planSearch" placeholder="Search plans..."
                       class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
                <button type="button" onclick="openModal('add-new-plan-modal')"
                        class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">Add New Plan</button>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="plansTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Name</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Description</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Price (USD)</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">ROI (%)</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Duration</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach ($investmentPlans as $plan)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200"
                        data-plan-id="{{ $plan->id }}"
                        data-plan-name="{{ $plan->name }}"
                        data-plan-description="{{ $plan->description }}"
                        data-plan-price="{{ $plan->price }}"
                        data-plan-roi="{{ $plan->roi }}"
                        data-plan-duration-value="{{ $plan->duration_value }}" {{-- Assuming you have duration_value and duration_unit --}}
                        data-plan-duration-unit="{{ $plan->duration_unit }}"
                    >
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white capitalize">{{ $plan->name }}</td>
                        <td class="px-6 py-4 whitespace-normal text-sm text-gray-300 max-w-xs">{{ $plan->description }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">${{ number_format($plan->price, 2) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $plan->roi }}%</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $plan->duration_value }} {{ ucfirst($plan->duration_unit) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                <button type="button" data-modal-target="edit-plan-modal"
                                        class="open-edit-plan-modal px-3 py-1.5 rounded-md text-white bg-blue-600 hover:bg-blue-700 transition-colors duration-200 text-xs font-medium">Edit</button>
                                <button type="button" data-modal-target="delete-plan-modal"
                                        class="open-delete-plan-modal px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Delete</button>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                    @if($investmentPlans->isEmpty())
                        <tr>
                            <td colspan="6" class="px-6 py-8 text-center text-gray-500 text-lg">No investment plans to display.</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2">
                </div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    {{-- Add New Plan Modal --}}
    <x-modal id="add-new-plan-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Add New Investment Plan</h2>
            </div>
            <form action="{{ route('admin.investment-plans.store') }}" method="POST">
                @csrf
                <div class="space-y-4 text-left">
                    <div>
                        <label for="new_name" class="block text-sm font-medium text-gray-300 mb-1">Plan Name</label>
                        <input type="text" name="name" id="new_name" maxlength="50" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="new_description" class="block text-sm font-medium text-gray-300 mb-1">Description</label>
                        <textarea name="description" id="new_description" rows="3" required
                                  class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                    <div>
                        <label for="new_price" class="block text-sm font-medium text-gray-300 mb-1">Price (USD)</label>
                        <input type="number" step="any" name="price" id="new_price" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="new_roi" class="block text-sm font-medium text-gray-300 mb-1">ROI (%)</label>
                        <input type="number" step="any" name="roi" id="new_roi" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="new_duration_value" class="block text-sm font-medium text-gray-300 mb-1">Duration Value</label>
                            <input type="number" name="duration_value" id="new_duration_value" min="1" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="new_duration_unit" class="block text-sm font-medium text-gray-300 mb-1">Duration Unit</label>
                            <select name="duration_unit" id="new_duration_unit" required
                                    class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                                <option value="days">Days</option>
                                <option value="months">Months</option>
                                <option value="years">Years</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition-colors duration-200">Add Plan</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('add-new-plan-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    {{-- Edit Plan Modal (Single Instance) --}}
    <x-modal id="edit-plan-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Edit Investment Plan: <span id="editModalPlanName"></span></h2>
            </div>
            <form action="" method="POST" id="editPlanForm">
                @csrf
                @method('PUT')
                <input type="hidden" name="id" id="editPlanId">
                <div class="space-y-4 text-left">
                    <div>
                        <label for="edit_name" class="block text-sm font-medium text-gray-300 mb-1">Plan Name</label>
                        <input type="text" name="name" id="edit_name" maxlength="50" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="edit_description" class="block text-sm font-medium text-gray-300 mb-1">Description</label>
                        <textarea name="description" id="edit_description" rows="3" required
                                  class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                    <div>
                        <label for="edit_price" class="block text-sm font-medium text-gray-300 mb-1">Price (USD)</label>
                        <input type="number" step="any" name="price" id="edit_price" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="edit_roi" class="block text-sm font-medium text-gray-300 mb-1">ROI (%)</label>
                        <input type="number" step="any" name="roi" id="edit_roi" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="edit_duration_value" class="block text-sm font-medium text-gray-300 mb-1">Duration Value</label>
                            <input type="number" name="duration_value" id="edit_duration_value" min="1" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="edit_duration_unit" class="block text-sm font-medium text-gray-300 mb-1">Duration Unit</label>
                            <select name="duration_unit" id="edit_duration_unit" required
                                    class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                                <option value="days">Days</option>
                                <option value="months">Months</option>
                                <option value="years">Years</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">Save Changes</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('edit-plan-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    {{-- Delete Plan Modal (Single Instance) --}}
    <x-modal id="delete-plan-modal">
        <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
            <div class="text-white mb-6">
                <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                </svg>
                <h2 class="mt-4 text-2xl font-bold">Delete Investment Plan</h2>
                <p class="mt-2 text-white">Are you sure you want to delete <span id="deleteModalPlanName" class="font-semibold"></span>?</p>
            </div>
            <form action="" method="POST" id="deletePlanForm">
                @csrf
                @method('DELETE')
                <input type="hidden" name="id" id="deletePlanId">
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Delete</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('delete-plan-modal')">No</button>
                </div>
            </form>
        </div>
    </x-modal>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const table = document.getElementById('plansTable');
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr'));
            const searchInput = document.getElementById('planSearch');
            const prevButton = document.getElementById('prevPage');
            const nextButton = document.getElementById('nextPage');
            const pageNumbersContainer = document.getElementById('pageNumbers');

            const rowsPerPage = 10;
            let currentPage = 1;
            let filteredRows = [];

            // Edit Modal elements
            const editPlanModal = document.getElementById('edit-plan-modal');
            const editPlanForm = document.getElementById('editPlanForm');
            const editPlanId = document.getElementById('editPlanId');
            const editModalPlanName = document.getElementById('editModalPlanName'); // Span inside H2
            const editNameInput = document.getElementById('edit_name');
            const editDescriptionInput = document.getElementById('edit_description');
            const editPriceInput = document.getElementById('edit_price');
            const editRoiInput = document.getElementById('edit_roi');
            const editDurationValueInput = document.getElementById('edit_duration_value');
            const editDurationUnitSelect = document.getElementById('edit_duration_unit');

            // Delete Modal elements
            const deletePlanModal = document.getElementById('delete-plan-modal');
            const deletePlanForm = document.getElementById('deletePlanForm');
            const deletePlanId = document.getElementById('deletePlanId');
            const deleteModalPlanName = document.getElementById('deleteModalPlanName'); // Span inside H2

            // Function to filter and paginate rows
            function renderTable() {
                const searchTerm = searchInput.value.toLowerCase();
                filteredRows = rows.filter(row => {
                    const textContent = row.textContent.toLowerCase();
                    return textContent.includes(searchTerm);
                });

                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

                if (totalPages === 0 && searchTerm !== "") {
                    currentPage = 1;
                } else if (totalPages === 0 && searchTerm === "") {
                    currentPage = 1;
                } else if (currentPage > totalPages) { // Ensure current page is valid after filtering
                    currentPage = totalPages;
                }


                const start = (currentPage - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const paginatedRows = filteredRows.slice(start, end);

                tbody.innerHTML = '';
                if (paginatedRows.length === 0 && searchTerm !== "") {
                    tbody.innerHTML = `<tr><td colspan="6" class="px-6 py-8 text-center text-gray-500">No matching plans found.</td></tr>`;
                } else if (paginatedRows.length === 0 && searchTerm === "") {
                     tbody.innerHTML = `<tr><td colspan="6" class="px-6 py-8 text-center text-gray-500">No investment plans to display.</td></tr>`;
                }

                paginatedRows.forEach(row => tbody.appendChild(row));

                updatePaginationControls(totalPages);
            }

            // Function to update pagination buttons and page numbers
            function updatePaginationControls(totalPages) {
                prevButton.disabled = currentPage === 1;
                nextButton.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersContainer.innerHTML = '';
                const maxPageButtons = 5;

                let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
                let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

                if (endPage - startPage + 1 < maxPageButtons) {
                    startPage = Math.max(1, endPage - maxPageButtons + 1);
                }

                if (startPage > 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }

                for (let i = startPage; i <= endPage; i++) {
                    const pageButton = document.createElement('button');
                    pageButton.textContent = i;
                    pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                        i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                    }`;
                    pageButton.addEventListener('click', () => {
                        currentPage = i;
                        renderTable();
                    });
                    pageNumbersContainer.appendChild(pageButton);
                }

                if (endPage < totalPages) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }
            }

            // Event Listeners for search and pagination
            searchInput.addEventListener('input', () => {
                currentPage = 1;
                renderTable();
            });

            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    renderTable();
                }
            });

            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    renderTable();
                }
            });

            // Handle opening the single Edit/Delete modals and populating their data
            tbody.addEventListener('click', function(event) {
                const editButton = event.target.closest('.open-edit-plan-modal');
                const deleteButton = event.target.closest('.open-delete-plan-modal');

                if (editButton) {
                    const row = editButton.closest('tr');
                    const planId = row.dataset.planId;
                    const planName = row.dataset.planName;
                    const planDescription = row.dataset.planDescription;
                    const planPrice = row.dataset.planPrice;
                    const planRoi = row.dataset.planRoi;
                    const planDurationValue = row.dataset.planDurationValue;
                    const planDurationUnit = row.dataset.planDurationUnit;

                    // Populate form fields
                    editPlanId.value = planId;
                    editModalPlanName.textContent = planName;
                    editNameInput.value = planName;
                    editDescriptionInput.value = planDescription;
                    editPriceInput.value = planPrice;
                    editRoiInput.value = planRoi;
                    editDurationValueInput.value = planDurationValue;
                    editDurationUnitSelect.value = planDurationUnit;

                    // Set form action dynamically
                    editPlanForm.action = `/admin/investment-plans/${planId}`; // Update this route as necessary

                    openModal('edit-plan-modal');
                } else if (deleteButton) {
                    const row = deleteButton.closest('tr');
                    const planId = row.dataset.planId;
                    const planName = row.dataset.planName;

                    deletePlanId.value = planId;
                    deleteModalPlanName.textContent = planName;

                    // Set form action dynamically
                    deletePlanForm.action = `/admin/investment-plans/${planId}`; // Update this route as necessary

                    openModal('delete-plan-modal');
                }
            });

            // Initial render
            renderTable();
        });
    </script>
</x-app-layout>
