<x-admin-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Expert Traders (Copy-Trade Plans)</h4>
                <p class="mt-2 text-gray-400 text-sm">Manage predefined copy trading plans offered by experts.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="expertTraderSearch" placeholder="Search plans..."
                       class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
                <button type="button" onclick="openModal('add-expert-trader-modal')"
                        class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">Add New Plan</button>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="expertTradersTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Plan Name</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Email</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Investment Range</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Duration</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">ROI (%)</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Risk Level</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Revenue Share (%)</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach ($expertTraders as $expert)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200"
                        data-expert-id="{{ $expert->id }}"
                        data-expert-name="{{ $expert->name }}"
                        data-expert-email="{{ $expert->email }}"
                        data-expert-min-investment-amount="{{ $expert->min_investment_amount }}"
                        data-expert-max-investment-amount="{{ $expert->max_investment_amount }}"
                        data-expert-expected-duration-value="{{ $expert->expected_duration_value }}"
                        data-expert-expected-duration-unit="{{ $expert->expected_duration_unit }}"
                        data-expert-risk-level="{{ $expert->risk_level }}"
                        data-expert-features="{{ $expert->features ? json_encode($expert->features) : '[]' }}" {{-- Ensure features is JSON encoded for JS --}}
                        data-expert-expected-roi-percentage="{{ $expert->expected_roi_percentage }}"
                        data-expert-revenue-share-percentage="{{ $expert->revenue_share_percentage }}"
                        data-expert-description="{{ $expert->description }}"
                        data-expert-status="{{ $expert->status }}"
                    >
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white capitalize">{{ $expert->name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $expert->email }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            ${{ number_format($expert->min_investment_amount, 0) }} - ${{ number_format($expert->max_investment_amount, 0) }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            {{ $expert->expected_duration_value }} {{ ucfirst($expert->expected_duration_unit) }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ number_format($expert->expected_roi_percentage, 2) }}%</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $expert->risk_level }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ number_format($expert->revenue_share_percentage, 2) }}%</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 rounded-full text-xs font-semibold
                                @if($expert->status === 'active') bg-green-600 text-white
                                @else bg-red-600 text-white @endif">
                                {{ ucfirst($expert->status) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                <a href="{{ route('admin.expert-traders.subscriptions', $expert->id) }}" class="px-3 py-1.5 rounded-md text-white bg-purple-600 hover:bg-purple-700 transition-colors duration-200 text-xs font-medium text-center">
                                    Subs
                                </a>
                                <button type="button" data-modal-target="edit-expert-trader-modal"
                                        class="open-edit-expert-trader-modal px-3 py-1.5 rounded-md text-white bg-blue-600 hover:bg-blue-700 transition-colors duration-200 text-xs font-medium">Edit</button>
                                <button type="button" data-modal-target="delete-expert-trader-modal"
                                        class="open-delete-expert-trader-modal px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Delete</button>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                    @if($expertTraders->isEmpty())
                        <tr>
                            <td colspan="9" class="px-6 py-8 text-center text-gray-500 text-lg">No copy-trade plans found.</td> {{-- Adjusted colspan --}}
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2">
                </div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    {{-- Add New Expert Trader Modal --}}
    <x-modal id="add-expert-trader-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Add New Copy-Trade Plan</h2>
            </div>
            <form action="{{ route('admin.expert-traders.store') }}" method="POST">
                @csrf
                <div class="space-y-4 text-left">
                    <div>
                        <label for="add_name" class="block text-sm font-medium text-gray-300 mb-1">Plan Name</label>
                        <input type="text" name="name" id="add_name" maxlength="255" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="add_email" class="block text-sm font-medium text-gray-300 mb-1">Expert Email (for contact)</label>
                        <input type="email" name="email" id="add_email" maxlength="255" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="add_min_investment_amount" class="block text-sm font-medium text-gray-300 mb-1">Min Investment (USD)</label>
                            <input type="number" step="0.01" name="min_investment_amount" id="add_min_investment_amount" min="0" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="add_max_investment_amount" class="block text-sm font-medium text-gray-300 mb-1">Max Investment (USD)</label>
                            <input type="number" step="0.01" name="max_investment_amount" id="add_max_investment_amount" min="0" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="add_expected_duration_value" class="block text-sm font-medium text-gray-300 mb-1">Duration Value</label>
                            <input type="number" name="expected_duration_value" id="add_expected_duration_value" min="1" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="add_expected_duration_unit" class="block text-sm font-medium text-gray-300 mb-1">Duration Unit</label>
                            <select name="expected_duration_unit" id="add_expected_duration_unit" required
                                    class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                                <option value="days">Day(s)</option>
                                <option value="weeks">Week(s)</option>
                                <option value="months">Month(s)</option>
                                <option value="years">Year(s)</option>
                            </select>
                        </div>
                    </div>
                    <div>
                        <label for="add_risk_level" class="block text-sm font-medium text-gray-300 mb-1">Risk Level</label>
                        <select name="risk_level" id="add_risk_level" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                            <option value="Low">Low</option>
                            <option value="Medium">Medium</option>
                            <option value="High">High</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Features (up to 3)</label>
                        <div id="add_features_container" class="space-y-2">
                            <input type="text" name="features[]" placeholder="e.g. Personalized support" maxlength="255"
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                            <input type="text" name="features[]" placeholder="e.g. AI-driven optimization" maxlength="255"
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                            <input type="text" name="features[]" placeholder="e.g. Daily market insights" maxlength="255"
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                    </div>
                    <div>
                        <label for="add_expected_roi_percentage" class="block text-sm font-medium text-gray-300 mb-1">Expected ROI (%)</label>
                        <input type="number" step="0.01" name="expected_roi_percentage" id="add_expected_roi_percentage" min="0" max="100" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="add_revenue_share_percentage" class="block text-sm font-medium text-gray-300 mb-1">Revenue Share (%)</label>
                        <input type="number" step="0.01" name="revenue_share_percentage" id="add_revenue_share_percentage" min="0" max="100" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="add_description_general" class="block text-sm font-medium text-gray-300 mb-1">General Description (for admin notes)</label>
                        <textarea name="description" id="add_description_general" rows="3"
                                  class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                    <div>
                        <label for="add_status" class="block text-sm font-medium text-gray-300 mb-1">Status</label>
                        <select name="status" id="add_status" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                            <option value="active">Active</option>
                            <option value="suspended">Suspended</option>
                        </select>
                    </div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition-colors duration-200">Add Plan</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('add-expert-trader-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    {{-- Edit Expert Trader Modal (Single Instance) --}}
    <x-modal id="edit-expert-trader-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Edit Copy-Trade Plan: <span id="editModalExpertName"></span></h2>
            </div>
            <form action="" method="POST" id="editExpertTraderForm">
                @csrf
                @method('PUT')
                <input type="hidden" name="id" id="editExpertId">
                <div class="space-y-4 text-left">
                    <div>
                        <label for="edit_name" class="block text-sm font-medium text-gray-300 mb-1">Plan Name</label>
                        <input type="text" name="name" id="edit_name" maxlength="255" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="edit_email" class="block text-sm font-medium text-gray-300 mb-1">Expert Email (for contact)</label>
                        <input type="email" name="email" id="edit_email" maxlength="255" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="edit_min_investment_amount" class="block text-sm font-medium text-gray-300 mb-1">Min Investment (USD)</label>
                            <input type="number" step="0.01" name="min_investment_amount" id="edit_min_investment_amount" min="0" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="edit_max_investment_amount" class="block text-sm font-medium text-gray-300 mb-1">Max Investment (USD)</label>
                            <input type="number" step="0.01" name="max_investment_amount" id="edit_max_investment_amount" min="0" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="edit_expected_duration_value" class="block text-sm font-medium text-gray-300 mb-1">Duration Value</label>
                            <input type="number" name="expected_duration_value" id="edit_expected_duration_value" min="1" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="edit_expected_duration_unit" class="block text-sm font-medium text-gray-300 mb-1">Duration Unit</label>
                            <select name="expected_duration_unit" id="edit_expected_duration_unit" required
                                    class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                                <option value="days">Day(s)</option>
                                <option value="weeks">Week(s)</option>
                                <option value="months">Month(s)</option>
                                <option value="years">Year(s)</option>
                            </select>
                        </div>
                    </div>
                    <div>
                        <label for="edit_risk_level" class="block text-sm font-medium text-gray-300 mb-1">Risk Level</label>
                        <select name="risk_level" id="edit_risk_level" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                            <option value="Low">Low</option>
                            <option value="Medium">Medium</option>
                            <option value="High">High</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Features (up to 3)</label>
                        <div id="edit_features_container" class="space-y-2">
                            {{-- Features will be populated here by JS --}}
                        </div>
                    </div>
                    <div>
                        <label for="edit_expected_roi_percentage" class="block text-sm font-medium text-gray-300 mb-1">Expected ROI (%)</label>
                        <input type="number" step="0.01" name="expected_roi_percentage" id="edit_expected_roi_percentage" min="0" max="100" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="edit_revenue_share_percentage" class="block text-sm font-medium text-gray-300 mb-1">Revenue Share (%)</label>
                        <input type="number" step="0.01" name="revenue_share_percentage" id="edit_revenue_share_percentage" min="0" max="100" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="edit_description_general" class="block text-sm font-medium text-gray-300 mb-1">General Description (for admin notes)</label>
                        <textarea name="description" id="edit_description_general" rows="3"
                                  class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                    <div>
                        <label for="edit_status" class="block text-sm font-medium text-gray-300 mb-1">Status</label>
                        <select name="status" id="edit_status" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                            <option value="active">Active</option>
                            <option value="suspended">Suspended</option>
                        </select>
                    </div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">Save Changes</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('edit-expert-trader-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    {{-- Delete Expert Trader Modal (Single Instance) --}}
    <x-modal id="delete-expert-trader-modal">
        <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
            <div class="text-white mb-6">
                <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                </svg>
                <h2 class="mt-4 text-2xl font-bold">Delete Expert Trader</h2>
                <p class="mt-2 text-white">Are you sure you want to delete expert trader: <span id="deleteModalExpertName" class="font-semibold"></span>?</p>
            </div>
            <form action="" method="POST" id="deleteExpertTraderForm">
                @csrf
                @method('DELETE')
                <input type="hidden" name="id" id="deleteExpertId">
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Delete</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('delete-expert-trader-modal')">No</button>
                </div>
            </form>
        </div>
    </x-modal>

    @if ($errors->any())
        <x-toast-danger>{{ json_encode($errors->messages()) }}</x-toast-danger>
    @endif

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const expertTradersTable = document.getElementById('expertTradersTable'); // Renamed table variable for clarity
            const tbody = expertTradersTable.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr'));
            const searchInput = document.getElementById('expertTraderSearch');
            const prevButton = document.getElementById('prevPage');
            const nextButton = document.getElementById('nextPage');
            const pageNumbersContainer = document.getElementById('pageNumbers');

            const rowsPerPage = 10;
            let currentPage = 1;
            let filteredRows = [];

            // Add Expert Trader Modal elements
            const addExpertTraderModal = document.getElementById('add-expert-trader-modal');

            // Edit Expert Trader Modal elements
            const editExpertTraderModal = document.getElementById('edit-expert-trader-modal');
            const editExpertTraderForm = document.getElementById('editExpertTraderForm');
            const editExpertId = document.getElementById('editExpertId');
            const editModalExpertName = document.getElementById('editModalExpertName');
            const editNameInput = document.getElementById('edit_name');
            const editEmailInput = document.getElementById('edit_email');
            const editMinInvestmentAmountInput = document.getElementById('edit_min_investment_amount'); // NEW
            const editMaxInvestmentAmountInput = document.getElementById('edit_max_investment_amount'); // NEW
            const editExpectedDurationValueInput = document.getElementById('edit_expected_duration_value'); // NEW
            const editExpectedDurationUnitSelect = document.getElementById('edit_expected_duration_unit'); // NEW
            const editRiskLevelSelect = document.getElementById('edit_risk_level'); // NEW
            const editFeaturesContainer = document.getElementById('edit_features_container'); // NEW
            const editExpectedRoiPercentageInput = document.getElementById('edit_expected_roi_percentage');
            const editRevenueSharePercentageInput = document.getElementById('edit_revenue_share_percentage');
            const editDescriptionGeneralInput = document.getElementById('edit_description_general'); // Adjusted ID
            const editStatusSelect = document.getElementById('edit_status');

            // Delete Expert Trader Modal elements
            const deleteExpertTraderModal = document.getElementById('delete-expert-trader-modal');
            const deleteExpertTraderForm = document.getElementById('deleteExpertTraderForm');
            const deleteExpertId = document.getElementById('deleteExpertId');
            const deleteModalExpertName = document.getElementById('deleteModalExpertName');


            // Function to filter and paginate rows
            function renderTable() {
                const searchTerm = searchInput.value.toLowerCase();
                filteredRows = rows.filter(row => {
                    const textContent = row.textContent.toLowerCase();
                    return textContent.includes(searchTerm);
                });

                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

                if (totalPages === 0 && searchTerm !== "") {
                    currentPage = 1;
                } else if (totalPages === 0 && searchTerm === "") {
                    currentPage = 1;
                } else if (currentPage > totalPages) {
                    currentPage = totalPages;
                }


                const start = (currentPage - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const paginatedRows = filteredRows.slice(start, end);

                tbody.innerHTML = '';
                if (paginatedRows.length === 0 && searchTerm !== "") {
                    tbody.innerHTML = `<tr><td colspan="9" class="px-6 py-8 text-center text-gray-500">No matching copy-trade plans found.</td></tr>`; // Adjusted colspan
                } else if (paginatedRows.length === 0 && searchTerm === "") {
                     tbody.innerHTML = `<tr><td colspan="9" class="px-6 py-8 text-center text-gray-500">No copy-trade plans to display.</td></tr>`; // Adjusted colspan
                }

                paginatedRows.forEach(row => tbody.appendChild(row));

                updatePaginationControls(totalPages);
            }

            // Function to update pagination buttons and page numbers
            function updatePaginationControls(totalPages) {
                prevButton.disabled = currentPage === 1;
                nextButton.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersContainer.innerHTML = '';
                const maxPageButtons = 5;

                let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
                let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

                if (endPage - startPage + 1 < maxPageButtons) {
                    startPage = Math.max(1, endPage - maxPageButtons + 1);
                }

                if (startPage > 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }

                for (let i = startPage; i <= endPage; i++) {
                    const pageButton = document.createElement('button');
                    pageButton.textContent = i;
                    pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                        i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                    }`;
                    pageButton.addEventListener('click', () => {
                        currentPage = i;
                        renderTable();
                    });
                    pageNumbersContainer.appendChild(pageButton);
                }

                if (endPage < totalPages) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }
            }

            // Function to generate feature input fields
            function generateFeatureInputs(featuresArray = []) {
                editFeaturesContainer.innerHTML = ''; // Clear previous inputs
                const placeholderFeatures = ['Personalized asset growth strategy', 'Priority customer support', 'AI-driven portfolio optimization']; // Fallback placeholders

                // Create inputs for existing features
                featuresArray.forEach((feature, index) => {
                    const input = document.createElement('input');
                    input.type = 'text';
                    input.name = 'features[]';
                    input.placeholder = placeholderFeatures[index] || `Feature ${index + 1}`;
                    input.maxLength = 255;
                    input.value = feature;
                    input.className = 'block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500';
                    editFeaturesContainer.appendChild(input);
                });

                // Add empty inputs if less than 3 features, or if no features
                for (let i = featuresArray.length; i < 3; i++) {
                    const input = document.createElement('input');
                    input.type = 'text';
                    input.name = 'features[]';
                    input.placeholder = placeholderFeatures[i] || `Feature ${i + 1}`;
                    input.maxLength = 255;
                    input.className = 'block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500';
                    editFeaturesContainer.appendChild(input);
                }
            }


            // Event Listeners for search and pagination
            searchInput.addEventListener('input', () => {
                currentPage = 1;
                renderTable();
            });

            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    renderTable();
                }
            });

            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    renderTable();
                }
            });

            // Handle opening the single Edit/Delete modals and populating their data
            tbody.addEventListener('click', function(event) {
                const editButton = event.target.closest('.open-edit-expert-trader-modal');
                const deleteButton = event.target.closest('.open-delete-expert-trader-modal');

                if (editButton) {
                    const row = editButton.closest('tr');
                    const expertId = row.dataset.expertId;
                    const expertName = row.dataset.expertName;
                    const expertEmail = row.dataset.expertEmail;
                    const expertMinInvestmentAmount = row.dataset.expertMinInvestmentAmount;
                    const expertMaxInvestmentAmount = row.dataset.expertMaxInvestmentAmount;
                    const expertExpectedDurationValue = row.dataset.expertExpectedDurationValue;
                    const expertExpectedDurationUnit = row.dataset.expertExpectedDurationUnit; // Corrected dataset property
                    const expertRiskLevel = row.dataset.expertRiskLevel;
                    const expertFeatures = JSON.parse(row.dataset.expertFeatures); // Parse JSON string back to array
                    const expertExpectedRoiPercentage = row.dataset.expertExpectedRoiPercentage; // Corrected dataset property
                    const expertRevenueSharePercentage = row.dataset.expertRevenueSharePercentage;
                    const expertDescription = row.dataset.expertDescription;
                    const expertStatus = row.dataset.expertStatus;

                    // Populate form fields
                    editExpertId.value = expertId;
                    editModalExpertName.textContent = expertName;
                    editNameInput.value = expertName;
                    editEmailInput.value = expertEmail;
                    editMinInvestmentAmountInput.value = expertMinInvestmentAmount;
                    editMaxInvestmentAmountInput.value = expertMaxInvestmentAmount;
                    editExpectedDurationValueInput.value = expertExpectedDurationValue;
                    // editExpectedDurationUnitSelect.value = expertExpectedDurationUnit;
                    const options = editExpectedDurationUnitSelect.options
                    console.log('options', options, expertExpectedDurationUnit);

                    for (let i = 0; i < options.length; i++) {
                        console.log('options', options[i].value, expertExpectedDurationUnit);
                        if (options[i].value === expertExpectedDurationUnit) {
                            options[i].selected = true;
                            break;
                        }
                    }

                    editRiskLevelSelect.value = expertRiskLevel;
                    generateFeatureInputs(expertFeatures); // Populate features
                    editExpectedRoiPercentageInput.value = expertExpectedRoiPercentage;
                    editRevenueSharePercentageInput.value = expertRevenueSharePercentage;
                    editDescriptionGeneralInput.value = expertDescription;
                    editStatusSelect.value = expertStatus;

                    // Set form action dynamically
                    editExpertTraderForm.action = `/admin/expert-traders/${expertId}`;

                    openModal('edit-expert-trader-modal');
                } else if (deleteButton) {
                    const row = deleteButton.closest('tr');
                    const expertId = row.dataset.expertId;
                    const expertName = row.dataset.expertName;

                    deleteExpertId.value = expertId;
                    deleteModalExpertName.textContent = expertName;

                    // Set form action dynamically
                    deleteExpertTraderForm.action = `/admin/expert-traders/${expertId}`;

                    openModal('delete-expert-trader-modal');
                }
            });

            // Initial render
            renderTable();
        });
    </script>
</x-admin-layout>
